/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaPagination;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class PaginationSqlHandler
extends SqlHandler<CriteriaPagination> {
    CriteriaPagination criteria;

    @Override
    public void setData(CriteriaPagination criteria) {
        this.criteria = criteria;
    }

    @Override
    public void startWithPreSelect(AbstractSqlWriter writer) {
        if (this.criteria.isValid()) {
            writer.write("SELECT * FROM (\n");
        }
    }

    @Override
    public void endWithPreSelect(AbstractSqlWriter writer) {
        if (this.criteria.isValid()) {
            Long tempLowerBound = (this.criteria.getPageNum() - 1L) * this.criteria.getPageSize();
            Long lowerBound = tempLowerBound == 0L ? tempLowerBound : tempLowerBound + 1L;
            Long upperBound = tempLowerBound == 0L ? lowerBound + this.criteria.getPageSize() : lowerBound + this.criteria.getPageSize() - 1L;
            writer.startRecursiveCommonTableExpression("WHERE rn BETWEEN " + lowerBound + " AND " + upperBound, "");
        }
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        if (this.criteria.isValid()) {
            writer.write(",\n row_number() over (");
            if (writer.getJdbcClient().getDbType().isPaginationOrderingSupported()) {
                String relTable;
                if (OptionsUtil.getOrderByMechanism((Options)writer.getOptions()).contains("ATTRIBUTE") || OptionsUtil.getOrderByMechanism((Options)writer.getOptions()).contains("RELATION")) {
                    writer.write("ORDER BY ");
                }
                boolean firstOrderBy = true;
                if (OptionsUtil.getOrderByMechanism((Options)writer.getOptions()).contains("ATTRIBUTE")) {
                    String relTable2;
                    String attrTable = writer.getFirstAlias(OseeDb.ATTRIBUTE_TABLE);
                    if (attrTable != null) {
                        writer.write(attrTable);
                        writer.write(".value");
                        firstOrderBy = false;
                    }
                    if (OptionsUtil.getOrderByMechanism((Options)writer.getOptions()).contains("RELATION") && (relTable2 = writer.getFirstAlias(OseeDb.RELATION_TABLE)) != null) {
                        if (!firstOrderBy) {
                            writer.write(", ");
                        }
                        writer.write(relTable2);
                        writer.write(".rel_type, ");
                        writer.write(relTable2);
                        writer.write(".rel_order ");
                        firstOrderBy = false;
                    }
                } else if (OptionsUtil.getOrderByMechanism((Options)writer.getOptions()).contains("RELATION") && (relTable = writer.getFirstAlias(OseeDb.RELATION_TABLE)) != null) {
                    if (!firstOrderBy) {
                        writer.write(", ");
                    }
                    writer.write(relTable);
                    writer.write(".rel_type, ");
                    writer.write(relTable);
                    writer.write(".rel_order ");
                    firstOrderBy = false;
                }
                if (firstOrderBy) {
                    writer.write("1");
                }
            }
            writer.write(") rn");
        } else {
            writer.write(",0 as rn");
        }
    }

    @Override
    public boolean shouldWriteAnd() {
        return false;
    }

    @Override
    public boolean criteriaIsValid() {
        return this.criteria.isValid();
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.PAGINATION.ordinal();
    }
}

