/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.health.AtsHealthEndpointApi;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckOperation;
import org.eclipse.osee.ats.rest.internal.util.health.operations.HealthOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;

public final class AtsHealthEndpointImpl
implements AtsHealthEndpointApi {
    private AtsApi atsApi;
    private JdbcService jdbcService;
    private OrcsApi orcsApi;

    public AtsHealthEndpointImpl() {
    }

    public AtsHealthEndpointImpl(OrcsApi orcsApi, AtsApi atsApi, JdbcService jdbcService) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.jdbcService = jdbcService;
    }

    public String get() {
        Thread.currentThread().setName("ATS Health Check Operation");
        AtsHealthCheckOperation validate = new AtsHealthCheckOperation(this.orcsApi, this.atsApi, this.jdbcService);
        XResultData rd = validate.run();
        return rd.toString().replaceAll("\n", "</br>");
    }

    public Boolean alive() {
        return true;
    }

    public XResultData dupArtReport(ArtifactId id, String newArtId) {
        HealthOperations ops = new HealthOperations(this.atsApi);
        return ops.getDuplicateArtifactReport(id, newArtId);
    }
}

