/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsOperationCache;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheck;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheckProvider;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.rest.internal.notify.OseeEmailServer;
import org.eclipse.osee.ats.rest.internal.util.AtsOperationCache;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckProviderService;
import org.eclipse.osee.ats.rest.internal.util.health.check.AtsHealthQueries;
import org.eclipse.osee.ats.rest.internal.util.health.check.TestDuplicateAttributesWithPersist;
import org.eclipse.osee.ats.rest.internal.util.health.check.TestWorkflowVersions;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.ILoggerListener;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public class AtsHealthCheckOperation {
    private final AtsApi atsApi;
    private final JdbcService jdbcService;
    boolean inTest = false;
    boolean persist = true;
    boolean debug = false;
    private Set<Long> aiIds;
    private IAtsOperationCache cache;
    private HealthCheckResults vResults;
    private final OrcsApi orcsApi;

    public AtsHealthCheckOperation(OrcsApi orcsApi, AtsApi atsApi, JdbcService jdbcService) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.jdbcService = jdbcService;
    }

    private List<IAtsHealthCheck> getHealthChecks() {
        LinkedList<IAtsHealthCheck> healthChecks = new LinkedList<IAtsHealthCheck>();
        healthChecks.add(new TestTeamDefinitionsLoad());
        healthChecks.add(new TestActionableItemsLoad());
        healthChecks.add(new TestWorkflowTeamDefinition());
        healthChecks.add(new TestWorkflowVersions());
        healthChecks.add(new TestWorkflowDefinition());
        healthChecks.add(new TestStateMgrAndDupStates());
        healthChecks.add(new TestCurrentState());
        healthChecks.add(new TestAssignees());
        healthChecks.add(new TestWorkflowHasAction());
        healthChecks.add(new TestTeamDefinitionsBaslineBranch());
        healthChecks.add(new TestTeamDefinitionsWorkDefRef());
        healthChecks.add(new TestTeamDefinitionsProgram());
        healthChecks.add(new TestActionableItemsTeamDefRef());
        healthChecks.add(new TestActionableItemsProgram());
        healthChecks.add(new TestVersions());
        healthChecks.add(new TestTeamWorkflows());
        healthChecks.add(new TestBranches());
        healthChecks.add(new TestDuplicateAttributesWithPersist());
        healthChecks.add(new TestDuplicateArtEntries());
        healthChecks.add(new TestReviews());
        healthChecks.add(new TestTasks());
        for (IAtsHealthCheckProvider provider : AtsHealthCheckProviderService.getHealthCheckProviders()) {
            healthChecks.addAll(provider.getHealthChecks());
        }
        return healthChecks;
    }

    public XResultData run() {
        this.cache = new AtsOperationCache(this.atsApi, this.debug);
        XResultData rd = new XResultData();
        String configDbName = this.atsApi.getConfigValue("DatabaseName");
        if (Strings.isInValid((String)configDbName)) {
            configDbName = "unknown AtsConfig.DatabaseName";
        }
        configDbName = configDbName.toUpperCase();
        rd.log(AHTML.heading((int)4, (String)(String.valueOf(configDbName) + " - ATS Health Check")));
        this.aiIds = this.atsApi.getConfigService().getConfigurations().getIdToAi().keySet();
        try {
            ElapsedTime time = new ElapsedTime("ATS Health Check", false, true);
            this.runIt(rd);
            this.cache = null;
            String elapsedStr = time.end(ElapsedTime.Units.MIN);
            rd.log("\n\n" + elapsedStr);
            this.outputResults(rd);
        }
        catch (Exception ex) {
            rd.errorf("Exception running reports [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    public void runIt(XResultData rd) {
        SevereLoggingMonitor monitorLog = new SevereLoggingMonitor();
        OseeLog.registerLoggerListener((ILoggerListener)monitorLog);
        int count = 0;
        this.vResults = new HealthCheckResults();
        this.vResults.setPersist(this.persist);
        if (this.inTest) {
            this.vResults.log("testMap1", "blah blah");
            this.vResults.log("testMap2", "blah blah");
            this.vResults.log("testMap1", "blah blah");
            this.vResults.log("testMap3", "blah blah");
        } else {
            List<IAtsHealthCheck> checks = this.getHealthChecks();
            IAtsChangeSet changes = null;
            if (this.persist) {
                changes = this.atsApi.createChangeSet(this.getClass().getSimpleName(), AtsCoreUsers.SYSTEM_USER);
            }
            this.handleCheckBefores(checks, changes, rd);
            count = this.handleChecks(count, checks, changes, rd);
            this.handleCheckAfters(checks, rd);
            if (this.persist) {
                changes.executeIfNeeded();
                rd.log("Changes Persisted\n");
            }
            checks = null;
            this.cache = null;
            for (IAtsHealthCheckProvider provider : AtsHealthCheckProviderService.getHealthCheckProviders()) {
                provider.clearCaches();
            }
        }
        this.vResults.addResultsMapToResultData(rd);
        rd.addTimeMapToResultData(new String[]{"CheckBefore", "Load", "Test", "CheckAfter"});
        rd.logf("Completed processing %s open work items.", new Object[]{count});
    }

    private void handleCheckBefores(List<IAtsHealthCheck> checks, IAtsChangeSet changes, XResultData rd) {
        for (IAtsHealthCheck check : checks) {
            String testName = "CheckBefore - " + check.getName();
            rd.logTimeStart(testName);
            boolean done = check.checkBefore(this.vResults, this.atsApi, this.cache);
            if (!done) continue;
            if (this.debug) {
                System.err.println(String.format("Processing CheckBefore - %s", check.getName()));
            }
            rd.logTimeSpent(testName);
        }
    }

    private int handleChecks(int count, List<IAtsHealthCheck> checks, IAtsChangeSet changes, XResultData rd) {
        List<Collection<Long>> artIdLists = this.loadWorkingWorkItemIds(rd);
        int x = 1;
        for (Collection<Long> artIdList : artIdLists) {
            if (this.debug) {
                System.err.println(String.format("Processing art check set %s/%s", x++, artIdLists.size()));
            }
            String loadStr = "Load Artifacts";
            rd.logTimeStart(loadStr);
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(artIdList);
            rd.logTimeSpent(loadStr);
            ArrayList<ArtifactToken> artifacts = new ArrayList<ArtifactToken>(allArtifacts.size());
            for (ArtifactToken artifact : allArtifacts) {
                if (this.atsApi.getStoreService().isDeleted((ArtifactId)artifact)) continue;
                artifacts.add(artifact);
            }
            count += artifacts.size();
            for (ArtifactToken artifact : artifacts) {
                if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                this.cache.addTeamWf(artifact);
            }
            for (ArtifactToken artifact : artifacts) {
                for (IAtsHealthCheck check : checks) {
                    try {
                        boolean done;
                        rd.logTimeStart(check.getName());
                        if (this.atsApi.getStoreService().isDeleted((ArtifactId)artifact)) continue;
                        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(artifact);
                        if (workItem.isTask()) {
                            this.cache.addTask((IAtsTask)workItem);
                        }
                        if (!(done = check.check(artifact, workItem, this.vResults, this.atsApi, (IAtsChangeSet)(this.persist ? changes : null), this.cache))) continue;
                        rd.logTimeSpent(check.getName());
                    }
                    catch (Exception ex) {
                        this.vResults.log((ArtifactId)artifact, check.getName(), "Error: Exception: " + Lib.exceptionToString((Exception)ex));
                    }
                }
            }
        }
        return count;
    }

    private void handleCheckAfters(List<IAtsHealthCheck> checks, XResultData rd) {
        for (IAtsHealthCheck check : checks) {
            String testName = "CheckAfter - " + check.getName();
            rd.logTimeStart(testName);
            boolean done = check.checkAfter(this.vResults, this.atsApi, this.cache);
            if (!done) continue;
            if (this.debug) {
                System.err.println(String.format("Processing CheckAfter - %s", check.getName()));
            }
            rd.logTimeSpent(testName);
        }
    }

    private List<Long> getInvalidIds(List<Long> ids) {
        ArrayList<Long> badIds = new ArrayList<Long>();
        for (Long id : ids) {
            if (this.aiIds.contains(id)) continue;
            badIds.add(id);
        }
        return badIds;
    }

    private Map<Long, String> getInWorkWorkItemsWorkDefId(XResultData rd) {
        HashMap<Long, String> artIdWorkDefId = new HashMap<Long, String>();
        rd.log("getInWorkWorkItemsWorkDefId - Started " + DateUtil.getMMDDYYHHMM());
        JdbcStatement chStmt = this.jdbcService.getClient().getStatement();
        try {
            chStmt.runPreparedQuery(AtsHealthQueries.getInWorkWorkItemsWorkDefId(this.atsApi), new Object[0]);
            while (chStmt.next()) {
                artIdWorkDefId.put(chStmt.getLong(1), chStmt.getString(2));
            }
        }
        finally {
            chStmt.close();
            rd.log("getInWorkWorkItemsWorkDefId - Completed " + DateUtil.getMMDDYYHHMM());
        }
        return artIdWorkDefId;
    }

    private List<Collection<Long>> loadWorkingWorkItemIds(XResultData rd) {
        String loadArtsStr = "Load Art Ids";
        rd.logTimeStart(loadArtsStr);
        List<Long> artIds = this.getCommonArtifactIds(rd);
        if (artIds.isEmpty()) {
            rd.error("Error: Artifact load returned 0 artifacts to check");
        }
        List subDivide = Collections.subDivide(artIds, (int)4000);
        rd.logTimeSpent(loadArtsStr);
        return subDivide;
    }

    private List<Long> getCommonArtifactIds(XResultData rd) {
        ArrayList<Long> artIds = new ArrayList<Long>();
        try (JdbcStatement chStmt = this.jdbcService.getClient().getStatement();){
            chStmt.runPreparedQuery(AtsHealthQueries.getWorkItemsInCurrentStateType(this.atsApi, StateType.Working), new Object[0]);
            while (chStmt.next()) {
                artIds.add(chStmt.getLong(1));
            }
        }
        return artIds;
    }

    private void outputResults(XResultData rd) {
        if (OseeProperties.isInTest() & rd.toString().contains("Error: ")) {
            throw new OseeStateException("Error in ATS Health Check: " + rd.toString(), new Object[0]);
        }
        String html = AHTML.simplePage((String)rd.toString().replaceAll("\n", "</br>"));
        html = html.replaceAll("Error: ", AHTML.color((String)"red", (String)"Error: "));
        try {
            this.emailResults(html);
        }
        catch (Exception ex) {
            OseeLog.log(AtsHealthCheckOperation.class, (Level)Level.SEVERE, (String)"Can't Email ATS Health Check results", (Throwable)ex);
        }
        try {
            this.saveResults(html);
        }
        catch (Exception ex) {
            OseeLog.log(AtsHealthCheckOperation.class, (Level)Level.SEVERE, (String)"Can't Save ATS Health Check results", (Throwable)ex);
        }
    }

    private void saveResults(String html) {
        String serverData = System.getProperty("osee.application.server.data");
        if (!Strings.isValid((String)serverData)) {
            serverData = System.getProperty("user.home");
        }
        String outputDirName = String.valueOf(serverData) + File.separator + "atsHealth";
        File outDir = new File(outputDirName);
        outDir.mkdir();
        String outputFileName = String.valueOf(outputDirName) + File.separator + Lib.getDateTimeString() + ".html";
        File outFile = new File(outputFileName);
        try {
            Lib.writeStringToFile((String)html, (File)outFile);
        }
        catch (Exception ex) {
            String exStr = AHTML.simplePage((String)Lib.exceptionToString((Exception)ex));
            try {
                Lib.writeStringToFile((String)exStr, (File)outFile);
            }
            catch (IOException ex1) {
                System.err.println(Lib.exceptionToString((Exception)ex1));
            }
        }
    }

    private void emailResults(String html) {
        String fromReplyEmail;
        IUserGroup userGroup = this.atsApi.userService().getUserGroup(AtsArtifactToken.AtsHealthUsers);
        if (userGroup == null) {
            return;
        }
        Collection emails = userGroup.getActiveMemberEmails();
        if (emails.isEmpty()) {
            return;
        }
        String dbName = "";
        String configDbName = this.atsApi.getConfigValue("DatabaseName");
        if (Strings.isValid((String)configDbName)) {
            dbName = " " + configDbName;
        }
        if (Strings.isInValid((String)(fromReplyEmail = this.atsApi.getConfigValue("NoReplyEmail")))) {
            fromReplyEmail = (String)emails.iterator().next();
        }
        OseeEmailServer emailMessage = OseeEmailServer.create(emails, fromReplyEmail, fromReplyEmail, String.valueOf(dbName) + " - ATS Health Check", html, OseeEmail.BodyType.Html);
        emailMessage.send();
    }

    private class TestActionableItemsLoad
    implements IAtsHealthCheck {
        private TestActionableItemsLoad() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            cache.getActionableItems();
            return true;
        }
    }

    private class TestActionableItemsProgram
    implements IAtsHealthCheck {
        private TestActionableItemsProgram() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken aiArt : cache.getActionableItems()) {
                ArtifactId progId = (ArtifactId)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
                if (!progId.isValid() || atsApi.getConfigService().getConfigurations().getIdToProgram().containsKey(progId.getId())) continue;
                results.log("TestActionableItemsProgram", String.format("Invalid Program Id %s for Actionable Item %s", progId, aiArt.toStringWithId()));
            }
            return true;
        }
    }

    private class TestActionableItemsTeamDefRef
    implements IAtsHealthCheck {
        private TestActionableItemsTeamDefRef() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken aiArt : cache.getActionableItems()) {
                ArtifactId teamDefArt = atsApi.getAttributeResolver().getSoleArtifactIdReference(aiArt, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (ArtifactId)ArtifactToken.SENTINEL);
                if (!teamDefArt.isValid()) continue;
                results.log("TestActionableItemsTeamDefRef", String.format("Invalid Team Def Ref for Actionable Item %s", aiArt.toStringWithId()));
            }
            return true;
        }
    }

    private class TestAssignees
    implements IAtsHealthCheck {
        private TestAssignees() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            if (workItem.isInWork()) {
                String currentStatename = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, (Object)"unknown");
                ArrayList<Long> userArtIds = new ArrayList<Long>();
                for (AtsUser user : atsApi.getWorkStateFactory().getUsers(currentStatename)) {
                    userArtIds.add(user.getArtifactId().getId());
                }
                ArrayList<Long> currUserArtIds = new ArrayList<Long>();
                for (String id : atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee)) {
                    if (Strings.isNumeric((String)id)) {
                        currUserArtIds.add(Long.valueOf(id));
                        continue;
                    }
                    results.log((ArtifactId)artifact, "TestAssignees", String.format("Error: Invalid Current State Assigne [%s] for %s", id, workItem.toStringWithId()));
                }
                if (Collections.setComplement(currUserArtIds, userArtIds).size() > 0 || Collections.setComplement(userArtIds, currUserArtIds).size() > 0) {
                    changes.setAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, Collections.castAll(userArtIds));
                    results.log((ArtifactId)artifact, "TestAssignees", String.format("Info: Updated Current State Assignees attr to [%s] for %s", userArtIds, workItem.toStringWithId()));
                }
            }
            return true;
        }
    }

    private class TestBranches
    implements IAtsHealthCheck {
        private TestBranches() {
        }

        public boolean checkAfter(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (Branch workingBranch : ((BranchQuery)((BranchQuery)((BranchQuery)AtsHealthCheckOperation.this.orcsApi.getQueryFactory().branchQuery().andIsOfType(new BranchType[]{BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.COMMITTED})).excludeArchived()).getResults().getList()) {
                Collection branchesLeftToCommit;
                ArtifactId assocArt = workingBranch.getAssociatedArtifact();
                if (!assocArt.isValid()) continue;
                IAtsTeamWorkflow teamWf = atsApi.getQueryService().getTeamWf(assocArt);
                if (teamWf == null) {
                    results.log("TestBranches", String.format("Error: Unexpected Assoc Id [%s] for Working Branch %s", assocArt.getIdString(), workingBranch.toStringWithId()));
                    continue;
                }
                if (!atsApi.getBranchService().getBranchState((BranchId)workingBranch).isCommitted()) {
                    Collection branchesCommittedTo = atsApi.getBranchService().getBranchesCommittedTo(teamWf);
                    if (branchesCommittedTo.isEmpty()) continue;
                    results.log((ArtifactId)teamWf.getStoreObject(), "TestBranches", "Error: TeamWorkflow " + teamWf.getAtsId() + " has committed branches but working branch [" + workingBranch + "] != COMMITTED");
                    continue;
                }
                if (atsApi.getBranchService().isArchived((BranchId)workingBranch) || !(branchesLeftToCommit = atsApi.getBranchService().getBranchesLeftToCommit(teamWf)).isEmpty()) continue;
                results.log((ArtifactId)teamWf.getStoreObject(), "TestBranches", "Error: TeamWorkflow " + teamWf.getAtsId() + " has committed all branches but working branch [" + workingBranch + "] != ARCHIVED");
            }
            return true;
        }
    }

    private class TestCurrentState
    implements IAtsHealthCheck {
        private TestCurrentState() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            if (workItem.isInWork()) {
                String currStateNameAttr;
                String currentStatename = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, (Object)"unknown");
                currentStatename = currentStatename.replaceFirst(";.*$", "");
                WorkDefinition workDef = workItem.getWorkDefinition();
                if (workDef.getStateByName(currentStatename) == null) {
                    results.log((ArtifactId)artifact, "TestCurrentStateIsInWorkDef", String.format("Error: Current State [%s] not valid for Work Definition [%s] for " + artifact.toStringWithId(), currentStatename, workDef.getName()));
                }
                if (!currentStatename.equals(currStateNameAttr = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, (Object)""))) {
                    changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, currentStatename);
                    results.log((ArtifactId)artifact, "TestCurrentStateIsInWorkDef", String.format("Info: Updated Current State Name attr to [%s] for %s", currentStatename, workItem.toStringWithId()));
                }
            }
            return true;
        }
    }

    private class TestDuplicateArtEntries
    implements IAtsHealthCheck {
        private TestDuplicateArtEntries() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            List artIds = atsApi.getQueryService().getArtifactIdsFromQuery(AtsHealthQueries.getMultipleArtEntriesonCommon(atsApi), new Object[0]);
            if (!artIds.isEmpty()) {
                results.log("TestDuplicateArtEntries", String.format("Error: Duplicate Art Ids [%s]", Collections.toString((String)",", (Iterable)artIds)));
            }
            return true;
        }
    }

    private class TestReviews
    implements IAtsHealthCheck {
        private TestReviews() {
        }

        public boolean checkAfter(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            Collection reviews = cache.getReviews().values();
            int x = 1;
            int size = reviews.size();
            for (IAtsAbstractReview review : reviews) {
                if (AtsHealthCheckOperation.this.debug) {
                    System.err.println(String.format("Processing review %s/%s", x++, size));
                }
                if (review.isStandAloneReview()) {
                    return true;
                }
                IAtsTeamWorkflow parent = cache.getParentTeamWorkflow((IAtsWorkItem)review, results);
                if (parent == null || !parent.isCompletedOrCancelled()) continue;
                results.log((ArtifactId)review.getStoreObject(), "TestOpenReviewsClosedCancelledParents", String.format("Error: Open review with comp/cancel parent %s", review.toStringWithId()));
            }
            return true;
        }
    }

    private class TestStateMgrAndDupStates
    implements IAtsHealthCheck {
        private TestStateMgrAndDupStates() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            ArrayList<String> foundStates = new ArrayList<String>();
            for (String stateAttr : atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.State)) {
                String state = stateAttr.replaceFirst(";.*$", "");
                if (foundStates.contains(state)) {
                    results.log((ArtifactId)artifact, "TestStateMgrAndDupStates", String.format("Error: Duplicate state [%s] for %s", state, workItem.toStringWithId()));
                    continue;
                }
                foundStates.add(state);
            }
            return true;
        }
    }

    private class TestTasks
    implements IAtsHealthCheck {
        private TestTasks() {
        }

        public boolean checkAfter(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            Collection tasks = cache.getTasks().values();
            int x = 1;
            int size = tasks.size();
            for (IAtsTask task : tasks) {
                IAtsTeamWorkflow parent;
                if (AtsHealthCheckOperation.this.debug) {
                    System.err.println("Processing task " + x++ + "/" + size);
                }
                if ((parent = cache.getParentTeamWorkflow((IAtsWorkItem)task, results)) == null) {
                    results.log((ArtifactId)task.getStoreObject(), "TestTasks", String.format("Error: Open task with no parent %s", task.toStringWithId()));
                    continue;
                }
                if (parent == null || !parent.isCompletedOrCancelled()) continue;
                results.log((ArtifactId)task.getStoreObject(), "TestTasks", String.format("Error: Open task with comp/cancel parent %s", task.toStringWithId()));
            }
            return true;
        }
    }

    private class TestTeamDefinitionsBaslineBranch
    implements IAtsHealthCheck {
        private TestTeamDefinitionsBaslineBranch() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken teamDefArt : cache.getTeamDefinitions()) {
                String branchId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1");
                BranchId branch = BranchId.valueOf((String)branchId);
                if (!branch.isValid()) continue;
                BranchToken branch2 = atsApi.getBranchService().getBranch(branch);
                if (branch2 == null) {
                    results.log("TestTeamDefinitionsBaslineBranch", String.format("Invalid Branch %s for Team Def %s", branch.getId(), teamDefArt.toStringWithId()));
                    continue;
                }
                if (atsApi.getBranchService().getBranchType((BranchId)branch2) == BranchType.BASELINE) continue;
                results.log("TestTeamDefinitionsBaslineBranch", String.format("Invalid BranchType %s for Branch %s for Team Def %s", atsApi.getBranchService().getBranchType((BranchId)branch2), branch.getId(), teamDefArt.toStringWithId()));
            }
            return true;
        }
    }

    private class TestTeamDefinitionsLoad
    implements IAtsHealthCheck {
        private TestTeamDefinitionsLoad() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            cache.getTeamDefinitions();
            return true;
        }
    }

    private class TestTeamDefinitionsProgram
    implements IAtsHealthCheck {
        private TestTeamDefinitionsProgram() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken teamDefArt : cache.getTeamDefinitions()) {
                ArtifactId progId = (ArtifactId)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
                if (!progId.isValid() || atsApi.getConfigService().getConfigurations().getIdToProgram().containsKey(progId.getId())) continue;
                results.log("TestTeamDefinitionsProgram", String.format("Invalid Program Id %s for Team Def %s", progId, teamDefArt.toStringWithId()));
            }
            return true;
        }
    }

    private class TestTeamDefinitionsWorkDefRef
    implements IAtsHealthCheck {
        private TestTeamDefinitionsWorkDefRef() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken teamDefArt : cache.getTeamDefinitions()) {
                for (AttributeTypeGeneric attributeTypeGeneric : Arrays.asList(AtsAttributeTypes.WorkflowDefinitionReference, AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference, AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference)) {
                    for (Object obj : atsApi.getAttributeResolver().getAttributeValues((ArtifactId)teamDefArt, (AttributeTypeToken)attributeTypeGeneric)) {
                        ArtifactId workDefId = (ArtifactId)obj;
                        if (!workDefId.isValid() || atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId) != null) continue;
                        results.log("TestTeamDefinitionsWorkDefRef", String.format("Invalid WorkDefRef %s for Team Def %s", workDefId.getId(), teamDefArt.toStringWithId()));
                    }
                }
            }
            return true;
        }
    }

    private class TestTeamWorkflows
    implements IAtsHealthCheck {
        private TestTeamWorkflows() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            if (workItem.isTeamWorkflow()) {
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                try {
                    List<Long> badIds;
                    if (!atsApi.getActionableItemService().hasActionableItems((IAtsWorkItem)teamWf)) {
                        results.log((ArtifactId)artifact, "TestTeamWorkflows", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has 0 ActionableItems");
                    }
                    if (teamWf.getTeamDefinition() == null) {
                        results.log((ArtifactId)artifact, "TestTeamWorkflows", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has no TeamDefinition");
                    }
                    if (!(badIds = AtsHealthCheckOperation.this.getInvalidIds(AtsObjects.toIds((Collection)atsApi.getActionableItemService().getActionableItems((IAtsWorkItem)teamWf)))).isEmpty()) {
                        results.log((ArtifactId)artifact, "TestTeamWorkflows", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has AI ids that don't exisit " + badIds);
                    }
                }
                catch (Exception ex) {
                    results.log((ArtifactId)artifact, "TestTeamWorkflows", String.valueOf(teamWf.getArtifactTypeName()) + " exception: " + ex.getLocalizedMessage());
                }
            }
            return true;
        }
    }

    private class TestVersions
    implements IAtsHealthCheck {
        private TestVersions() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken verArt : atsApi.getQueryService().getArtifacts(AtsArtifactTypes.Version)) {
                Version version = atsApi.getVersionService().getVersionById((ArtifactId)verArt);
                String branchId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1");
                BranchId branch = BranchId.valueOf((String)branchId);
                if (branch.isValid()) {
                    BranchToken branch2 = null;
                    try {
                        branch2 = atsApi.getBranchService().getBranch(branch);
                    }
                    catch (ItemDoesNotExist itemDoesNotExist) {}
                    if (branch2 == null) {
                        results.log("TestVersions", String.format("Invalid Branch %s for Team Def %s", branch.getId(), verArt.toStringWithId()));
                    } else if (atsApi.getBranchService().getBranchType((BranchId)branch2) != BranchType.BASELINE) {
                        results.log("TestVersions", String.format("Invalid BranchType %s for Branch %s for Team Def %s", atsApi.getBranchService().getBranchType((BranchId)branch2), branch.getId(), verArt.toStringWithId()));
                    }
                }
                for (IAtsVersion parallelVersion : atsApi.getVersionService().getParallelVersions((IAtsVersion)version)) {
                    if (parallelVersion == null) continue;
                    try {
                        if (!parallelVersion.isBranchInvalid()) continue;
                        results.log((ArtifactId)verArt, "TestVersions", "Error: [" + parallelVersion.toStringWithId() + "] in parallel config without parent branch id");
                    }
                    catch (Exception ex) {
                        results.log((ArtifactId)verArt, "TestVersions", "Error: " + verArt.getName() + " exception testing testVersionArtifacts: " + ex.getLocalizedMessage());
                    }
                }
            }
            return true;
        }
    }

    private class TestWorkflowDefinition
    implements IAtsHealthCheck {
        private TestWorkflowDefinition() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            XResultData rd = new XResultData();
            Map<Long, String> artIdToworkDefId = AtsHealthCheckOperation.this.getInWorkWorkItemsWorkDefId(rd);
            for (Map.Entry<Long, String> entry : artIdToworkDefId.entrySet()) {
                String workDefId = entry.getValue();
                WorkDefinition workDef = atsApi.getWorkDefinitionService().getWorkDefinition(Long.valueOf(workDefId));
                if (workDef != null) continue;
                results.log(ArtifactId.valueOf((Long)entry.getKey()), "TestWorkflowDefinition", String.format("Error: Invalid Work Def Ref for workflow %s", entry.getKey()));
            }
            return true;
        }
    }

    private class TestWorkflowHasAction
    implements IAtsHealthCheck {
        private TestWorkflowHasAction() {
        }

        public boolean checkBefore(HealthCheckResults results, AtsApi atsApi, IAtsOperationCache cache) {
            for (ArtifactToken art : AtsHealthCheckOperation.this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andRelationNotExists(AtsRelationTypes.ActionToWorkflow_TeamWorkflow).getResults().getList()) {
                results.log((ArtifactId)art, "TestWorkflowHasAction", String.format("Error: Workflow %s has no parent Action", art.toStringWithId()));
            }
            return true;
        }
    }

    private class TestWorkflowTeamDefinition
    implements IAtsHealthCheck {
        private TestWorkflowTeamDefinition() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            ArtifactId teamDefArt = atsApi.getAttributeResolver().getSoleArtifactIdReference(artifact, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (ArtifactId)ArtifactToken.SENTINEL);
            if (teamDefArt.isValid() && !atsApi.getConfigService().getConfigurations().getIdToTeamDef().containsKey(teamDefArt.getId())) {
                results.log("TestWorkflowTeamDefinition", String.format("Invalid Team Def Ref for workflow %s", workItem.toStringWithId()));
            }
            return true;
        }
    }
}

