/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.util;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.workflow.util.AbstractDuplicateWorkflowOperation;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class DuplicateWorkflowAtStartStateOperation
extends AbstractDuplicateWorkflowOperation {
    public DuplicateWorkflowAtStartStateOperation(Collection<IAtsTeamWorkflow> teamWfs, String title, AtsUser asUser, AtsApi atsApi) {
        super(teamWfs, title, asUser, atsApi);
    }

    public XResultData run() {
        XResultData results = this.validate();
        if (results.isErrors()) {
            return results;
        }
        this.oldToNewMap = new HashMap();
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Duplicate Workflow - At Start State", this.asUser);
        Date createdDate = new Date();
        AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
        for (IAtsTeamWorkflow teamWf : this.teamWfs) {
            LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
            assignees.addAll(teamWf.getStateMgr().getAssignees());
            IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
            assignees.addAll(AtsApiService.get().getTeamDefinitionService().getLeads(teamDef));
            AtsUser user = this.atsApi.getUserService().getCurrentUser();
            if (!assignees.contains(user)) {
                assignees.add(user);
            }
            IAtsTeamWorkflow newTeamWf = this.atsApi.getActionService().createTeamWorkflow(teamWf.getParentAction(), teamDef, (Collection)teamWf.getActionableItems(), assignees, changes, createdDate, createdBy, null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
            String title = this.getTitle((IAtsWorkItem)teamWf);
            changes.setSoleAttributeValue((IAtsWorkItem)newTeamWf, (AttributeTypeToken)CoreAttributeTypes.Name, title);
            changes.add((Object)newTeamWf);
            this.oldToNewMap.put(teamWf, newTeamWf);
        }
        changes.execute();
        return results;
    }
}

