/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelperAdapter;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class TransitionHelper
extends TransitionHelperAdapter {
    private IAtsChangeSet changes;
    private IAtsWorkItemService workItemService;
    private final List<IAtsTransitionHook> transitionHooks = new ArrayList<IAtsTransitionHook>();

    public TransitionHelper(TransitionData transData, IAtsChangeSet changes, AtsApi atsApi) {
        super(atsApi, transData);
        this.changes = changes;
        this.workItemService = atsApi.getWorkItemService();
    }

    public TransitionHelper(String name, Collection<IAtsWorkItem> workItems, String toStateName, Collection<AtsUser> toAssignees, String cancellationReason, IAtsChangeSet changes, AtsApi atsApi, TransitionOption ... transitionOption) {
        super(atsApi, new TransitionData());
        this.transData.setName(name);
        this.transData.setWorkItems(workItems);
        this.transData.setToStateName(toStateName);
        this.transData.setCancellationReason(cancellationReason);
        this.transData.setCancellationReasonAttrType((AttributeTypeToken)AtsAttributeTypes.CancelledReason);
        this.transData.setToAssignees(toAssignees);
        TransitionOption[] transitionOptionArray = transitionOption;
        int n = transitionOption.length;
        int n2 = 0;
        while (n2 < n) {
            TransitionOption opt = transitionOptionArray[n2];
            this.transData.getTransitionOptions().add(opt);
            ++n2;
        }
        this.changes = changes;
        this.handleSetAtsApi(atsApi);
    }

    @Override
    public boolean isOverrideAssigneeCheck() {
        return this.getTransitionOptions().contains(TransitionOption.OverrideAssigneeCheck);
    }

    @Override
    public boolean isOverrideWorkingBranchCheck() {
        return this.transData.getTransitionOptions().contains(TransitionOption.OverrideWorkingBranchCheck);
    }

    @Override
    public boolean isReload() {
        return !this.transData.getTransitionOptions().contains(TransitionOption.OverrideReload);
    }

    @Override
    public boolean isOverrideTransitionValidityCheck() {
        return this.transData.getTransitionOptions().contains(TransitionOption.OverrideTransitionValidityCheck);
    }

    @Override
    public Collection<IAtsWorkItem> getWorkItems() {
        return this.transData.getWorkItems();
    }

    public TransitionData getCancellationReason(TransitionData transitionData) {
        return transitionData;
    }

    public String getName() {
        return this.transData.getName();
    }

    public Collection<AtsUser> getToAssignees(IAtsWorkItem workItem) {
        return this.transData.getToAssignees();
    }

    public String getToStateName() {
        return this.transData.getToStateName();
    }

    public void addTransitionOption(TransitionOption transitionOption) {
        this.transData.getTransitionOptions().add(transitionOption);
    }

    public void removeTransitionOption(TransitionOption transitionOption) {
        this.transData.getTransitionOptions().remove(transitionOption);
    }

    public void setToStateName(String toStateName) {
        this.transData.setToStateName(toStateName);
    }

    public IAtsChangeSet getChangeSet() {
        if (this.changes == null) {
            AtsUser transitionUser = this.getTransitionUser();
            this.changes = this.atsApi.createChangeSet(this.getName(), transitionUser);
        }
        return this.changes;
    }

    @Override
    public boolean isExecuteChanges() {
        return this.transData.isExecuteChanges();
    }

    public void setExecuteChanges(boolean executeChanges) {
        this.transData.setExecuteChanges(executeChanges);
    }

    public Collection<IAtsTransitionHook> getTransitionHooks() {
        try {
            ArrayList<IAtsTransitionHook> hooks = new ArrayList<IAtsTransitionHook>();
            hooks.addAll(this.workItemService.getTransitionHooks());
            hooks.addAll(this.transitionHooks);
            return hooks;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(TransitionHelper.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public AtsApi getServices() {
        return this.atsApi;
    }

    public Collection<TransitionOption> getTransitionOptions() {
        return this.transData.getTransitionOptions();
    }

    @Override
    public void setAtsApi(AtsApi atsApi) {
        this.handleSetAtsApi(atsApi);
    }

    private void handleSetAtsApi(AtsApi atsApi) {
        if (atsApi != null) {
            this.atsApi = atsApi;
            this.workItemService = atsApi.getWorkItemService();
            if (this.transData.getTransitionUser() == null) {
                this.transData.setTransitionUser(atsApi.getUserService().getCurrentUser());
            }
        } else {
            this.workItemService = null;
        }
    }

    public void setCancellationReasonDetails(String cancelReasonDetails) {
        this.transData.setCancellationReasonDetails(cancelReasonDetails);
    }

    public void setCancellationReason(String cancelReason) {
        this.transData.setCancellationReason(cancelReason);
    }

    public String getCancellationReasonDetails() {
        return this.transData.getCancellationReasonDetails();
    }

    public String getCancellationReason() {
        return this.transData.getCancellationReason();
    }

    @Override
    public AttributeTypeToken getCancellationReasonAttrType() {
        return this.transData.getCancellationReasonAttrType();
    }

    public void addTransitionHook(IAtsTransitionHook transitionHook) {
        this.transitionHooks.add(transitionHook);
    }
}

