/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsCommitBranchWhenCompleteHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsCommitBranchWhenCompleteHook.class.getSimpleName();
    }

    public String getDescription() {
        return "When the Workflow is transitioned to Completed, archive the branch, if it is not already archived.";
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes) {
        try {
            BranchToken branch;
            if (workItem instanceof IAtsTeamWorkflow && toState.getStateType().isCompleted() && (branch = AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)workItem, true)) != null && branch.isValid() && !AtsApiService.get().getBranchService().isArchived((BranchId)branch)) {
                AtsApiService.get().getBranchService().archiveBranch((BranchId)branch);
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsCommitBranchWhenCompleteHook.class, (Level)Level.SEVERE, (String)"Error archiving branch in complete hook", (Throwable)ex);
        }
    }
}

