/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.core.validator.AtsXWidgetValidator;

public class AtsXComboBooleanValidator
extends AtsXWidgetValidator {
    private static final List<String> TRUE_FALSE_VALUES = Arrays.asList("true", "false");

    @Override
    public WidgetResult validateTransition(IAtsWorkItem workItem, IValueProvider provider, WidgetDefinition widgetDef, StateDefinition fromStateDef, StateDefinition toStateDef, AtsApi atsServices) {
        WidgetResult result = WidgetResult.Success;
        if ("XComboBooleanDam".equals(widgetDef.getXWidgetName())) {
            result = this.validateWidgetIsRequired(provider, widgetDef, fromStateDef, fromStateDef);
            if (!result.isSuccess()) {
                return result;
            }
            for (String value : provider.getValues()) {
                if (this.isValid(value)) continue;
                return new WidgetResult(WidgetStatus.Invalid_Range, "[%s] value [%s] must be true or false", new Object[]{provider.getName(), value});
            }
        }
        return result;
    }

    private boolean isValid(String value) {
        return TRUE_FALSE_VALUES.contains(value);
    }
}

