/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.internal.state.StateManager;
import org.eclipse.osee.ats.core.internal.state.StateManagerStore;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class AtsStateFactory
implements IAtsStateFactory {
    private final IAtsWorkStateFactory workStateFactory;
    private final IAtsLogFactory logFactory;
    private final AtsApi atsApi;
    Map<Id, IAtsStateManager> idToStateManager = new HashMap<Id, IAtsStateManager>();
    Map<Id, TransactionId> idToTransactionId = new HashMap<Id, TransactionId>();

    public AtsStateFactory(AtsApi atsApi, IAtsWorkStateFactory workStateFactory, IAtsLogFactory logFactory) {
        this.atsApi = atsApi;
        this.workStateFactory = workStateFactory;
        this.logFactory = logFactory;
    }

    public IAtsStateManager getStateManager(IAtsWorkItem workItem) {
        IAtsStateManager stateMgr = this.idToStateManager.get(workItem);
        boolean sameTransaction = true;
        TransactionId transId = this.idToTransactionId.get(workItem);
        TransactionId workItemTransaction = this.atsApi.getStoreService().getTransactionId(workItem);
        if (workItemTransaction.isValid()) {
            sameTransaction = workItemTransaction.equals(transId);
            this.idToTransactionId.put((Id)workItem, workItemTransaction);
        }
        if (stateMgr == null || !sameTransaction) {
            stateMgr = new StateManager(workItem, this.atsApi);
            this.idToStateManager.put((Id)workItem, stateMgr);
            StateManagerStore.load(workItem, stateMgr, this.atsApi.getAttributeResolver(), this.workStateFactory);
        }
        return stateMgr;
    }

    public void writeToStore(AtsUser asUser, IAtsWorkItem workItem, IAtsChangeSet changes) {
        String stateName = workItem.getCurrentStateName();
        StateDefinition stateDef = workItem.getWorkDefinition().getStateByName(stateName);
        changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, stateDef.getStateType().name());
        StateManagerStore.writeToStore(asUser, workItem, (StateManager)workItem.getStateMgr(), this.atsApi.getAttributeResolver(), changes, this.workStateFactory);
    }

    public void load(IAtsWorkItem workItem, IAtsStateManager stateMgr) {
        StateManagerStore.load(workItem, stateMgr, this.atsApi.getAttributeResolver(), this.workStateFactory);
    }

    public void clearStateManager(Id id) {
        this.idToStateManager.put(id, null);
    }

    public void setStateMgr(IAtsWorkItem workItem, IAtsStateManager stateMgr) {
        this.idToStateManager.put((Id)workItem, stateMgr);
        this.idToTransactionId.put((Id)workItem, this.atsApi.getStoreService().getTransactionId(workItem));
    }
}

