/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.log;

import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AtsLogWriter {
    private final ILogStorageProvider storageProvider;
    public static final String ATS_LOG_TAG = "AtsLog";
    public static final String LOG_ITEM_TAG = "Item";
    public static final Pattern LOG_ITEM_PATTERN = Pattern.compile("<Item date=\"(.*?)\" msg=\"(.*?)\" state=\"(.*?)\" type=\"(.*?)\" userId=\"(.*?)\"/>");
    public static final Pattern LOG_ITEM_TAG_PATTERN = Pattern.compile("<Item ");
    private final IAtsLog atsLog;

    public AtsLogWriter(IAtsLog atsLog, ILogStorageProvider storageProvider) {
        this.atsLog = atsLog;
        this.storageProvider = storageProvider;
    }

    public void save(IAtsChangeSet changes) {
        try {
            Result result;
            String currentXml;
            Document doc = Jaxp.newDocumentNamespaceAware();
            Element rootElement = doc.createElement(ATS_LOG_TAG);
            doc.appendChild(rootElement);
            for (IAtsLogItem item : this.atsLog.getLogItems()) {
                Element element = doc.createElement(LOG_ITEM_TAG);
                element.setAttribute("type", item.getType().name());
                element.setAttribute("date", String.valueOf(item.getDate().getTime()));
                element.setAttribute("userId", item.getUserId());
                element.setAttribute("state", item.getState());
                element.setAttribute("msg", item.getMsg());
                rootElement.appendChild(element);
            }
            String documentXml = Jaxp.getDocumentXml((Document)doc);
            if (!documentXml.equals(currentXml = this.storageProvider.getLogXml()) && (result = this.storageProvider.saveLogXml(documentXml, changes)).isFalse()) {
                OseeLog.log(AtsLogWriter.class, (Level)OseeLevel.SEVERE_POPUP, (String)("Can't create ats log document: " + result.getText()));
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsLogWriter.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't create ats log document", (Throwable)ex);
        }
        this.atsLog.setDirty(false);
    }
}

