/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config.tx;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.Csci;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxProgram;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.config.tx.AbstractAtsConfigTxObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class AtsConfigTxProgram
extends AbstractAtsConfigTxObject<IAtsConfigTxProgram>
implements IAtsConfigTxProgram {
    IAtsProgram program;

    public AtsConfigTxProgram(IAtsObject atsObject, AtsApi atsApi, IAtsChangeSet changes, IAtsConfigTx cfgTx) {
        super(atsObject, atsApi, changes, cfgTx);
        Conditions.assertTrue((boolean)(atsObject instanceof IAtsProgram), (String)"AtsObject must be of type IAtsProgram", (Object[])new Object[0]);
        this.program = (IAtsProgram)atsObject;
    }

    public IAtsConfigTxProgram andTeamDef(IAtsTeamDefinitionArtifactToken teamDefTok) {
        IAtsTeamDefinition teamDef = this.cfgTx.getTeamDef((ArtifactId)teamDefTok);
        if (teamDef == null || teamDef.isInvalid()) {
            teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)teamDefTok);
        }
        Conditions.assertNotNull((Object)teamDef, (String)"Team Definition must be created before Program %s", (Object[])new Object[]{this.program});
        this.changes.relate((Object)this.program, AtsRelationTypes.TeamDefinitionToProgram_TeamDefinition, (Object)teamDef);
        this.changes.setSoleAttributeValue((IAtsObject)this.program, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (Object)teamDef);
        this.changes.setSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)this.program);
        return this;
    }

    public IAtsConfigTxProgram andCsci(Csci ... cscis) {
        Csci[] csciArray = cscis;
        int n = cscis.length;
        int n2 = 0;
        while (n2 < n) {
            Csci csci = csciArray[n2];
            this.changes.addAttribute((IAtsObject)this.program, (AttributeTypeToken)AtsAttributeTypes.CSCI, (Object)csci.name());
            ++n2;
        }
        return this;
    }

    public IAtsProgram getProgram() {
        return this.program;
    }
}

