/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.util;

import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiUtils {
    private OsgiUtils() {
    }

    private static String getAnnotationKey(String annotationKeyMethodName, Annotation theAnnotation) {
        try {
            Object key = theAnnotation.getClass().getMethod(annotationKeyMethodName, new Class[0]).invoke((Object)theAnnotation, new Object[0]);
            return key instanceof String ? (String)key : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <A extends Annotation, I> Map<String, Class<I>> findImplementations(String packagePath, Class<A> annotationClass, String annotationKeyMethodName, Class<I> interfaceClass) {
        ArrayList implementationList = new ArrayList();
        BundleContext bundleContext = FrameworkUtil.getBundle(OsgiUtils.class).getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Collection resources = bundleWiring.listResources(packagePath, "*.class", 1);
        resources.forEach(resource -> {
            try {
                String key;
                Class<?> theImplementationClass;
                Object theAnnotation;
                String className = resource.substring(0, resource.indexOf(46)).replace('/', '.');
                Class<?> aClass = classLoader.loadClass(className);
                if (interfaceClass.isAssignableFrom(aClass) && Objects.nonNull(theAnnotation = (theImplementationClass = aClass).getAnnotation(annotationClass)) && Objects.nonNull(key = OsgiUtils.getAnnotationKey(annotationKeyMethodName, theAnnotation))) {
                    implementationList.add(new AbstractMap.SimpleImmutableEntry(key, theImplementationClass));
                }
            }
            catch (Exception exception) {}
        });
        return implementationList.stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

