/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.io.InputStream;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.synchronization.ExportRequest;
import org.eclipse.osee.define.api.synchronization.ImportRequest;
import org.eclipse.osee.define.api.synchronization.SynchronizationEndpoint;
import org.eclipse.osee.define.operations.publishing.PublishingPermissions;
import org.eclipse.osee.define.operations.synchronization.BadDocumentRootException;
import org.eclipse.osee.define.operations.synchronization.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;

public class SynchronizationEndpointImpl
implements SynchronizationEndpoint {
    private final DefineOperations defineOperations;

    private static void verifyAccess() {
        try {
            PublishingPermissions.verify();
        }
        catch (OseeAccessDeniedException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    public SynchronizationEndpointImpl(DefineOperations defineOperations) {
        this.defineOperations = Objects.requireNonNull(defineOperations, "SynchronizationEndpointImpl::new, parameter \"defineOperations\" cannot be null.");
    }

    public InputStream exporter(ExportRequest exportRequest) {
        SynchronizationEndpointImpl.verifyAccess();
        try {
            return this.defineOperations.getSynchronizationOperations().exporter(exportRequest);
        }
        catch (IllegalArgumentException | BadDocumentRootException | UnknownSynchronizationArtifactTypeException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public void importer(ImportRequest importRequest, InputStream inputStream) {
        SynchronizationEndpointImpl.verifyAccess();
        try {
            this.defineOperations.getSynchronizationOperations().importer(importRequest, inputStream);
        }
        catch (IllegalArgumentException | BadDocumentRootException | UnknownSynchronizationArtifactTypeException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

