/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing.templatemanager;

import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateSafeNames;
import org.eclipse.osee.define.api.publishing.templatemanager.TemplateManagerEndpoint;
import org.eclipse.osee.define.operations.publishing.PublishingPermissions;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;

public class TemplateManagerEndpointImpl
implements TemplateManagerEndpoint {
    private final DefineOperations defineOperations;

    private static void verifyAccess() {
        try {
            PublishingPermissions.verify();
        }
        catch (OseeAccessDeniedException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private static void verifyAccessNonGroup() {
        try {
            PublishingPermissions.verify();
        }
        catch (OseeAccessDeniedException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    public TemplateManagerEndpointImpl(DefineOperations defineOperations) {
        this.defineOperations = Objects.requireNonNull(defineOperations, "TemplateManagerEndpointImpl::new, parameter \"defineOperations\" cannot be null.");
    }

    public void deleteCache() {
        TemplateManagerEndpointImpl.verifyAccess();
        try {
            this.defineOperations.getTemplateManagerOperations().deleteCache();
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplate getPublishingTemplate(PublishingTemplateRequest publishingTemplateRequest) {
        TemplateManagerEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(publishingTemplateRequest);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplate getPublishingTemplate(String primaryKey, String secondaryKey) {
        TemplateManagerEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(primaryKey, secondaryKey);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplateSafeNames getPublishingTemplateSafeNames() {
        TemplateManagerEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getTemplateManagerOperations().getPublishingTemplateSafeNames();
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

