/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.define.rest.internal.wordupdate.IElementExtractor;
import org.eclipse.osee.define.rest.internal.wordupdate.WordExtractorData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MergeEditArtifactElementExtractor
implements IElementExtractor {
    private Element oleDataElement;
    private final Document document;
    private final String guid;

    public MergeEditArtifactElementExtractor(String guid, Document document) {
        this.guid = guid;
        this.document = document;
    }

    @Override
    public Element getOleDataElement() {
        return this.oleDataElement;
    }

    @Override
    public Collection<WordExtractorData> extractElements() throws DOMException {
        LinkedList<WordExtractorData> artifactElements = new LinkedList<WordExtractorData>();
        LinkedList<Element> sectList = new LinkedList<Element>();
        Element rootElement = this.document.getDocumentElement();
        this.oleDataElement = null;
        NodeList nodeList = rootElement.getElementsByTagName("*");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getNodeName().endsWith("wx:sect")) {
                sectList.add(element);
            }
            if (element.getNodeName().endsWith("body")) {
                WordExtractorData extractorData = new WordExtractorData();
                extractorData.addParent(element);
                extractorData.setGuid(this.guid);
                artifactElements.add(extractorData);
            } else if (this.oleDataElement == null && element.getNodeName().endsWith("docOleData")) {
                this.oleDataElement = element;
            }
            ++i;
        }
        if (!sectList.isEmpty()) {
            this.handleMultiSectTags(sectList);
        }
        return artifactElements;
    }

    private void handleMultiSectTags(Collection<Element> sectList) {
        boolean containTag = false;
        for (Element sectElem : sectList) {
            containTag |= this.cleanUpParagraph(sectElem);
        }
        if (!containTag) {
            throw new OseeCoreException("This document does not contain the approporate tags to be correctly saved.", new Object[0]);
        }
    }

    private boolean cleanUpParagraph(Node rootNode) {
        boolean worked = false;
        boolean delete = false;
        Node node = rootNode.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            if (node.getNodeName().endsWith("sub-section")) {
                worked = this.cleanUpParagraph(node);
            } else {
                String content = node.getTextContent();
                if (content != null && content.contains("LISTNUM\"listreset\"")) {
                    delete = true;
                }
                if (delete) {
                    rootNode.removeChild(node);
                }
            }
            node = nextNode;
        }
        return worked || delete;
    }
}

