/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.api.importing.IArtifactExtractorDelegate;
import org.eclipse.osee.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUtilities;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Readers;
import org.eclipse.osee.orcs.OrcsApi;

public class WordOutlineExtractor
extends AbstractArtifactExtractor {
    private static final String PARAGRAPH_TAG_WITH_ATTRS = "<w:p ";
    private static final String PARAGRAPH_TAG_EMPTY = "<w:p/>";
    private static final String PARAGRAPH_TAG = "<w:p>";
    private static final String TABLE_TAG_WITH_ATTRS = "<w:tbl ";
    private static final String TABLE_TAG_EMPTY = "<w:tbl/>";
    private static final String TABLE_TAG = "<w:tbl>";
    private static final CharSequence[] BODY_TAGS = new CharSequence[]{"<w:p>", "<w:p/>", "<w:p ", "<w:tbl>", "<w:tbl/>", "<w:tbl ", "</w:body>"};
    private static final Pattern internalAttributeElementsPattern = Pattern.compile("<((\\w+:)?(\\w+))(\\s+.*?)((/>)|(>(.*?)</\\1>))", 42);
    private static final Pattern proofErrTagKiller = Pattern.compile("</?w:proofErr.*?/?>");
    private static final int NAMESPACE_GROUP = 2;
    private static final int ELEMENT_NAME_GROUP = 3;
    private static final int ATTRIBUTE_BLOCK_GROUP = 4;
    private static final int CONTENT_GROUP = 8;
    private final Matcher reqNumberMatcher = Pattern.compile("(\\d+\\.)*(\\d+\\.?)\\s*").matcher("");
    private final Matcher reqListMatcher = Pattern.compile("\\w+\\)", 2).matcher("");
    private final Stack<String> currentListStack = new Stack();
    private final int maxExtractionDepth = 0;
    private Stack<String> clonedCurrentListStack = new Stack();
    private int lastDepthNumber;
    private String headerNumber = "";
    private String listIdentifier = "";
    private boolean forceBody;
    private boolean forcePrimaryType;
    private String paragraphStyle;

    public String getName() {
        return "Word Outline";
    }

    public String getDescription() {
        return "Extract data from a Word XML file with an outline, making an artifact for each outline numbered section.";
    }

    @Override
    public boolean isDelegateRequired() {
        return true;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }
        };
    }

    private void handleFormatError(URI source, String message) {
        throw new OseeStateException("File format error: %s in file [%s]", new Object[]{message, source.getPath()});
    }

    @Override
    protected XResultData extractFromSource(OrcsApi orcsApi, XResultData results, URI source, RoughArtifactCollector collector) throws IOException {
        try (Reader reader = null;){
            CharSequence element;
            reader = new BufferedReader(new InputStreamReader(source.toURL().openStream(), "UTF-8"));
            if (Readers.forward((Reader)reader, (CharSequence[])new CharSequence[]{"<w:body>"}) == null) {
                this.handleFormatError(source, "no start of body tag");
            }
            StringBuilder content = new StringBuilder(2000);
            IArtifactExtractorDelegate delegate = this.getDelegate();
            while ((element = Readers.forward((Reader)reader, (CharSequence[])BODY_TAGS)) != null) {
                if (element == "</w:body>") {
                    delegate.finish(orcsApi, results, collector);
                    XResultData xResultData = results;
                    return xResultData;
                }
                content.setLength(0);
                content.append(element);
                boolean emptyTagWithAttrs = false;
                if (element == PARAGRAPH_TAG_WITH_ATTRS || element == TABLE_TAG_WITH_ATTRS) {
                    if (Readers.forward((Reader)reader, (Appendable)content, (CharSequence[])new CharSequence[]{">"}) == null) {
                        this.handleFormatError(source, "did not find expected end of tag");
                    }
                    emptyTagWithAttrs = content.toString().endsWith("/>");
                }
                if (element == PARAGRAPH_TAG || !emptyTagWithAttrs && element == PARAGRAPH_TAG_WITH_ATTRS) {
                    Readers.xmlForward((Reader)reader, (Appendable)content, (CharSequence)"w:p");
                } else if (element == TABLE_TAG || !emptyTagWithAttrs && element == TABLE_TAG_WITH_ATTRS) {
                    Readers.xmlForward((Reader)reader, (Appendable)content, (CharSequence)"w:tbl");
                } else if (element != PARAGRAPH_TAG_WITH_ATTRS && element != TABLE_TAG_WITH_ATTRS && element != PARAGRAPH_TAG_EMPTY && element != TABLE_TAG_EMPTY) {
                    throw new IllegalStateException("Unexpected element returned");
                }
                content = new StringBuilder(proofErrTagKiller.matcher(content).replaceAll(""));
                this.forcePrimaryType = false;
                this.headerNumber = "";
                this.listIdentifier = "";
                this.paragraphStyle = null;
                this.parseContentDetails(content, new Stack<String>());
                results.combine(delegate.processContent(orcsApi, results, collector, this.forceBody, this.forcePrimaryType, this.headerNumber, this.listIdentifier, this.paragraphStyle, content.toString(), element == PARAGRAPH_TAG));
            }
            this.handleFormatError(source, "did not find expected end of body tag");
        }
        return results;
    }

    private void parseContentDetails(CharSequence content, Stack<String> parentElementNames) {
        Matcher matcher = internalAttributeElementsPattern.matcher(content);
        while (matcher.find()) {
            String elementContent;
            String elementName = matcher.group(3);
            String elementNamespace = matcher.group(2);
            String elementAttributes = matcher.group(4) == null ? "" : matcher.group(4);
            String string = elementContent = matcher.group(8) == null ? "" : matcher.group(8);
            if ("forceBodyOn".equals(elementName)) {
                this.forceBody = true;
            } else if ("forceBodyOff".equals(elementName)) {
                this.forceBody = false;
            } else if ("pStyle".equals(elementName)) {
                this.paragraphStyle = WordOutlineExtractor.getAttributeValue("w:val", elementAttributes);
            } else if ("forcePrimaryType".equals(elementName)) {
                this.forcePrimaryType = true;
            } else if (elementNamespace.startsWith("w") && "t".equals(elementName)) {
                String numberCandidate = WordOutlineExtractor.getAttributeValue("wx:val", elementAttributes);
                this.reqNumberMatcher.reset(numberCandidate);
                this.reqListMatcher.reset(numberCandidate);
                if (this.reqNumberMatcher.matches()) {
                    if (WordUtilities.isHeadingStyle(this.paragraphStyle)) {
                        this.headerNumber = numberCandidate;
                        if (this.headerNumber.endsWith(".0")) {
                            this.headerNumber = this.headerNumber.substring(0, this.headerNumber.length() - 2);
                        }
                    }
                } else if (this.reqListMatcher.matches() && this.isListStyle(parentElementNames)) {
                    this.listIdentifier = this.processListId(Integer.parseInt(WordOutlineExtractor.getAttributeValue("w:val", elementAttributes)), numberCandidate);
                }
            }
            parentElementNames.push(elementName);
            this.parseContentDetails(elementContent, parentElementNames);
            parentElementNames.pop();
        }
    }

    private static final String getAttributeValue(String attributeName, String attributeStorage) {
        int startIndex;
        attributeName = String.valueOf(attributeName) + "=\"";
        String attribute = "";
        int index = attributeStorage.indexOf(attributeName);
        if (index != -1 && (startIndex = 1 + index + attributeName.length()) < attributeStorage.length()) {
            attribute = attributeStorage.substring(startIndex, attributeStorage.indexOf(34, startIndex)).trim();
        }
        return attribute;
    }

    private boolean isListStyle(Stack<String> parentElementNames) {
        Iterator iter = parentElementNames.iterator();
        return iter.hasNext() && ((String)iter.next()).equals("ilvl") && iter.hasNext() && ((String)iter.next()).equals("listPr");
    }

    private String processListId(int currentDepthNumber, String numberCandidate) throws IllegalArgumentException {
        String id = "";
        if (currentDepthNumber == 0) {
            this.currentListStack.clear();
            this.currentListStack.push(numberCandidate);
            this.clonedCurrentListStack = (Stack)this.currentListStack.clone();
            this.lastDepthNumber = currentDepthNumber;
        } else {
            int i = currentDepthNumber;
            while (i <= this.lastDepthNumber) {
                this.currentListStack.pop();
                ++i;
            }
            this.lastDepthNumber = currentDepthNumber;
            this.currentListStack.push(numberCandidate);
            this.clonedCurrentListStack = (Stack)this.currentListStack.clone();
        }
        while (!this.clonedCurrentListStack.empty()) {
            id = String.valueOf(this.clonedCurrentListStack.pop()) + id;
        }
        if (currentDepthNumber > 0) {
            return null;
        }
        return id.replaceAll("\\)", ".");
    }
}

