/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateSafeNames;
import org.eclipse.osee.define.api.publishing.templatemanager.TemplateManagerOperations;
import org.eclipse.osee.define.operations.publishing.templatemanager.IsPublishingTemplateProvider;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCacheKey;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateProvider;
import org.eclipse.osee.define.util.OsgiUtils;
import org.eclipse.osee.define.util.Validation;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

public class TemplateManagerOperationsImpl
implements TemplateManagerOperations {
    private static TemplateManagerOperationsImpl templateManagerOperationsImpl = null;
    private final JdbcService jdbcService;
    private final Pattern keyPrefixPattern;
    private final Log logger;
    private final OrcsApi orcsApi;
    private final List<PublishingTemplateProvider> publishingTemplateProviders;
    private final Map<String, PublishingTemplateProvider> publishingTemplateProvidersByKeyPrefix;

    private TemplateManagerOperationsImpl(JdbcService jdbcService, Log logger, OrcsApi orcsApi) {
        this.jdbcService = jdbcService;
        this.keyPrefixPattern = Pattern.compile("(^[A-Z]+)-");
        this.logger = logger;
        this.orcsApi = orcsApi;
        Map<String, Class<PublishingTemplateProvider>> publishingTemplateProviderClassByKeyPrefixMap = OsgiUtils.findImplementations("org/eclipse/osee/define/operations/publishing/templatemanager", IsPublishingTemplateProvider.class, "key", PublishingTemplateProvider.class);
        this.publishingTemplateProvidersByKeyPrefix = publishingTemplateProviderClassByKeyPrefixMap.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, PublishingTemplateProvider>((String)entry.getKey(), this.newPublishingTemplateProviderInstance((Class)entry.getValue()))).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.publishingTemplateProviders = this.publishingTemplateProvidersByKeyPrefix.values().stream().collect(Collectors.toUnmodifiableList());
    }

    public static synchronized TemplateManagerOperationsImpl create(JdbcService jdbcService, Log logger, OrcsApi orcsApi) {
        return Objects.isNull(templateManagerOperationsImpl) ? (templateManagerOperationsImpl = new TemplateManagerOperationsImpl(Objects.requireNonNull(jdbcService), Objects.requireNonNull(logger), Objects.requireNonNull(orcsApi))) : templateManagerOperationsImpl;
    }

    public void deleteCache() {
        this.publishingTemplateProviders.forEach(PublishingTemplateProvider::deleteCache);
    }

    public PublishingTemplate getPublishingTemplate(PublishingTemplateRequest publishingTemplateRequest) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(publishingTemplateRequest, "publishingTemplateRequest", message, "is invalid", p -> !p.isValid()))) {
            String exceptionMessage = Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "getPublishingTemplate", message);
            throw new IllegalArgumentException(exceptionMessage);
        }
        boolean isNoTags = Boolean.valueOf(OseeInfo.getValue((JdbcClient)this.jdbcService.getClient(), (String)"osee.publish.no.tags"));
        return this.publishingTemplateProviders.stream().max(Comparator.comparing(publishingTemplateProvider -> publishingTemplateProvider.getApplicabilityRating(publishingTemplateRequest), Integer::compare)).flatMap(publishingTemplateProvider -> publishingTemplateProvider.getTemplate(publishingTemplateRequest, isNoTags)).map(PublishingTemplateInternal::getBean).orElse(PublishingTemplate.SENTINEL);
    }

    public PublishingTemplate getPublishingTemplate(String primaryKey, String secondaryKey) {
        Message message = null;
        message = Validation.verifyParameter(primaryKey, "primayKey", message);
        if (Objects.nonNull(message = Validation.verifyParameter(secondaryKey, "secondaryKey", message))) {
            String exceptionMessage = Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "getPublishingTemplate", message);
            throw new IllegalArgumentException(exceptionMessage);
        }
        PublishingTemplateCacheKey publishingTemplateCacheKey = PublishingTemplateCacheKey.valueOf(primaryKey);
        switch (publishingTemplateCacheKey) {
            case SAFE_NAME: 
            case NAME: {
                return this.publishingTemplateProviders.stream().map(publishingTemplateProvider -> publishingTemplateProvider.getTemplate(publishingTemplateCacheKey, secondaryKey)).flatMap(Optional::stream).findFirst().map(PublishingTemplateInternal::getBean).orElse(PublishingTemplate.SENTINEL);
            }
            case IDENTIFIER: {
                Matcher prefixMatcher = this.keyPrefixPattern.matcher(secondaryKey);
                if (!prefixMatcher.matches()) {
                    return PublishingTemplate.SENTINEL;
                }
                String prefix = prefixMatcher.group(0);
                String localIdentifier = secondaryKey.substring(prefixMatcher.end(0) + 2);
                PublishingTemplateProvider publishingTemplateProvider2 = this.publishingTemplateProvidersByKeyPrefix.get(prefix);
                if (Objects.isNull(publishingTemplateProvider2)) {
                    return PublishingTemplate.SENTINEL;
                }
                return publishingTemplateProvider2.getTemplate(publishingTemplateCacheKey, localIdentifier).map(PublishingTemplateInternal::getBean).orElse(PublishingTemplate.SENTINEL);
            }
        }
        return null;
    }

    public PublishingTemplateSafeNames getPublishingTemplateSafeNames() {
        return new PublishingTemplateSafeNames(this.publishingTemplateProviders.stream().map(PublishingTemplateProvider::getPublishingTemplateSafeNames).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private PublishingTemplateProvider newPublishingTemplateProviderInstance(Class<? extends PublishingTemplateProvider> publishingTemplateProviderClass) {
        try {
            return publishingTemplateProviderClass.getConstructor(Log.class, OrcsApi.class).newInstance(this.logger, this.orcsApi);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

