/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.search.tagger.HasTagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagCollector;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class AttributeTokenSqlHandler
extends SqlHandler<CriteriaAttributeKeywords>
implements HasTagProcessor {
    private CriteriaAttributeKeywords criteria;
    private String attrAlias;
    private String artAlias;
    private TagProcessor tagProcessor;

    @Override
    public void setTagProcessor(TagProcessor tagProcessor) {
        this.tagProcessor = tagProcessor;
    }

    @Override
    public TagProcessor getTagProcessor() {
        return this.tagProcessor;
    }

    @Override
    public void setData(CriteriaAttributeKeywords criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        List<QueryOption> asList;
        Collection types = this.criteria.getTypes();
        IdJoinQuery joinQuery = null;
        if (!this.criteria.isIncludeAllTypes() && types.size() > 1) {
            HashSet<AttributeTypeId> typeIds = new HashSet<AttributeTypeId>();
            for (AttributeTypeId type : types) {
                typeIds.add(type);
            }
            joinQuery = writer.writeJoin(typeIds);
        }
        if ((asList = Arrays.asList(this.criteria.getOptions())).contains(QueryOption.CASE__MATCH) && asList.contains(QueryOption.TOKEN_DELIMITER__EXACT) && asList.contains(QueryOption.TOKEN_MATCH_ORDER__MATCH) || this.criteria.getOptions().equals(QueryOption.EXACT_MATCH_OPTIONS)) {
            this.attrAlias = writer.startCommonTableExpression("att");
            this.writeAttrWithNoGamma(writer, joinQuery);
        } else {
            String gammaAlias = writer.startCommonTableExpression("gamma");
            this.writeGammaWith(writer, joinQuery);
            this.attrAlias = writer.startCommonTableExpression("att");
            this.writeAttrWith(writer, joinQuery, gammaAlias);
        }
    }

    private void writeGammaWith(AbstractSqlWriter writer, AbstractJoinQuery joinQuery) {
        Collection values = this.criteria.getValues();
        int valueCount = values.size();
        int valueIdx = 0;
        String jIdAlias = null;
        for (String value : values) {
            ArrayList<Long> tags = new ArrayList<Long>();
            this.tokenize(value, tags);
            int tagsSize = tags.size();
            writer.write("  ( \n");
            if (tagsSize == 0) {
                writer.write("SELECT gamma_id FROM osee_attribute att");
                if (joinQuery != null) {
                    writer.write(", ");
                    jIdAlias = writer.writeTable(OseeDb.OSEE_JOIN_ID_TABLE);
                }
                writer.write(" WHERE ");
                if (Strings.isValid((String)value)) {
                    writer.writeEqualsParameter("value", value);
                } else {
                    writer.write("value is null or value = ''");
                }
                if (!this.criteria.isIncludeAllTypes()) {
                    writer.writeAnd();
                    if (joinQuery == null) {
                        writer.writeEqualsParameter("attr_type_id", this.criteria.getTypes().iterator().next());
                    } else {
                        writer.writeEqualsAnd("att", "attr_type_id", jIdAlias, "id");
                        writer.writeEqualsParameter(jIdAlias, "query_id", joinQuery.getQueryId());
                    }
                }
            } else {
                int tagIdx = 0;
                while (tagIdx < tagsSize) {
                    Long tag = (Long)tags.get(tagIdx);
                    writer.write(" SELECT gamma_id FROM osee_search_tags WHERE ");
                    writer.writeEqualsParameter("coded_tag_id", tag);
                    if (tagIdx + 1 < tagsSize) {
                        writer.write("\n INTERSECT \n");
                    }
                    ++tagIdx;
                }
            }
            writer.write("\n  ) ");
            if (valueIdx + 1 < valueCount) {
                writer.write("\n UNION ALL \n");
            }
            ++valueIdx;
        }
    }

    private void writeAttrWith(AbstractSqlWriter writer, AbstractJoinQuery joinQuery, String gammaAlias) {
        writer.write(" SELECT DISTINCT art_id FROM osee_attribute att, osee_txs txs, ");
        String jIdAlias = null;
        if (joinQuery != null) {
            jIdAlias = writer.writeTable(OseeDb.OSEE_JOIN_ID_TABLE);
            writer.write(", ");
        }
        writer.write(gammaAlias);
        writer.write("\n WHERE \n");
        writer.write("   att.gamma_id = ");
        writer.write(gammaAlias);
        writer.write(".gamma_id");
        if (!this.criteria.isIncludeAllTypes()) {
            writer.writeAnd();
            if (joinQuery == null) {
                writer.writeEqualsParameter("attr_type_id", this.criteria.getTypes().iterator().next());
            } else {
                writer.writeEqualsAnd("att", "attr_type_id", jIdAlias, "id");
                writer.writeEqualsParameter(jIdAlias, "query_id", joinQuery.getQueryId());
            }
        }
        writer.writeAnd();
        writer.writeEqualsAnd("att", "txs", "gamma_id");
        writer.writeTxBranchFilter("txs", true);
    }

    private void writeAttrWithNoGamma(AbstractSqlWriter writer, AbstractJoinQuery joinQuery) {
        writer.write(" SELECT DISTINCT art_id FROM osee_attribute att, osee_txs txs ");
        String jIdAlias = null;
        if (joinQuery != null) {
            writer.writeCommaIfNotFirst();
            jIdAlias = writer.writeTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        writer.write("\n WHERE \n");
        if (!this.criteria.isIncludeAllTypes()) {
            if (joinQuery == null) {
                writer.writeEqualsParameterAnd("attr_type_id", this.criteria.getTypes().iterator().next());
            } else {
                writer.writeEqualsAnd("att", "attr_type_id", jIdAlias, "id");
                writer.writeEqualsParameterAnd(jIdAlias, "query_id", joinQuery.getQueryId());
            }
        }
        writer.writeEqualsAnd("att", "txs", "gamma_id");
        writer.writeTxBranchFilter("txs", true);
        if (this.criteria.getValues().size() == 1) {
            writer.write(" and att.value = '" + (String)this.criteria.getValues().iterator().next() + "' ");
        }
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        writer.addTable(this.attrAlias);
        this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        writer.getMainTableAlias(OseeDb.TXS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEquals(this.artAlias, this.attrAlias, "art_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_TOKENIZED_VALUE.ordinal();
    }

    private void tokenize(String value, final Collection<Long> codedTags) {
        TagCollector collector = new TagCollector(){

            @Override
            public void addTag(String word, Long codedTag) {
                codedTags.add(codedTag);
            }
        };
        this.getTagProcessor().collectFromString(value, collector);
    }
}

