/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.HasArtifactType;
import org.eclipse.osee.framework.core.util.WordMLWriter;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;

public class PublishingArtifactError {
    private final List<Object> things;
    private final String errorDescription;

    public <T extends NamedId & HasArtifactType> PublishingArtifactError(T thing, String errorDescription) {
        this.things = List.of(thing);
        this.errorDescription = errorDescription;
    }

    public <T extends NamedId & HasArtifactType> PublishingArtifactError(List<T> things, String errorDescription) {
        this.things = List.of(things);
        this.errorDescription = errorDescription;
    }

    public void publish(StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder, "PublishingArtifactError::publish, parameter \"stringBuilder\" cannot be null.");
        String indent1 = IndentedString.indentString((int)1);
        String indent2 = IndentedString.indentString((int)2);
        stringBuilder.append(indent1).append("Error: ").append("\n").append(indent2).append(this.errorDescription).append("\n");
        for (Object thing : this.things) {
            String identifier = ((NamedId)thing).getId().toString();
            String name = ((NamedId)thing).getName();
            String artifactTypeName = ((HasArtifactType)thing).getArtifactType().getName();
            stringBuilder.append(indent1).append("Artifact:").append("\n").append(indent2).append("Identifier: ").append(identifier).append("\n").append(indent2).append("Name:       ").append(name).append("\n").append(indent2).append("Type:       ").append(artifactTypeName).append("\n");
        }
    }

    public void publish(WordMLWriter wordMlWriter) {
        Objects.requireNonNull(wordMlWriter, "PublishingArtifactError::publish, parameter \"wordMlWriter\" cannot be null.");
        String thingIdentifiers = this.things.stream().map(thing -> ((NamedId)thing).getId().toString()).collect(Collectors.joining("\n"));
        String thingNames = this.things.stream().map(thing -> ((NamedId)thing).getName()).collect(Collectors.joining("\n"));
        String thingArtifactTypes = this.things.stream().map(thing -> ((HasArtifactType)thing).getArtifactType().getName()).collect(Collectors.joining("\n"));
        wordMlWriter.addErrorRow(thingIdentifiers, thingNames, thingArtifactTypes, this.errorDescription);
    }
}

