/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.mim.types.MimUserColumnPreference;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class MimUserPreference
extends PLGenericDBObject {
    public static final MimUserPreference SENTINEL = new MimUserPreference();
    private boolean isInEditMode = false;
    private boolean hasBranchPref = false;
    private List<MimUserColumnPreference> columnPreferences = new LinkedList<MimUserColumnPreference>();

    public MimUserPreference(ArtifactReadable artifact, BranchId branch, boolean hasWriteAccess) {
        super(artifact);
        this.setHasBranchPref(this.hasBranchAttribute(artifact.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.MimBranchPreferences), branch));
        this.setInEditMode(this.filterBranches(artifact.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.MimBranchPreferences), branch) && hasWriteAccess);
        this.setColumnPreferences(artifact.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.MimColumnPreferences));
    }

    public MimUserPreference(ArtifactReadable artifact, BranchId branch) {
        this(artifact, branch, false);
    }

    public MimUserPreference() {
    }

    public boolean isInEditMode() {
        return this.isInEditMode;
    }

    public void setInEditMode(boolean isInEditMode) {
        this.isInEditMode = isInEditMode;
    }

    public List<MimUserColumnPreference> getColumnPreferences() {
        return this.columnPreferences;
    }

    public void setColumnPreferences(List<String> columnPreferences) {
        this.columnPreferences = new LinkedList<MimUserColumnPreference>();
        for (String preference : columnPreferences) {
            if (!preference.contains(":")) continue;
            String[] preferences = preference.split(":");
            this.columnPreferences.add(new MimUserColumnPreference(preferences[0].split("\"")[1], Boolean.parseBoolean(preferences[1].split("\"")[0])));
        }
    }

    public boolean isHasBranchPref() {
        return this.hasBranchPref;
    }

    public void setHasBranchPref(boolean hasBranchPref) {
        this.hasBranchPref = hasBranchPref;
    }

    @JsonIgnore
    private boolean filterBranches(List<String> branches, BranchId branch) {
        for (String editValues : branches) {
            if (!editValues.contains(String.valueOf(branch.getIdString()) + ":true") && !editValues.contains(String.valueOf(branch.getIdString()) + ":false") || !editValues.contains(":")) continue;
            return Boolean.parseBoolean(editValues.split(String.valueOf(branch.getIdString()) + ":")[1].split("\"")[0]);
        }
        return false;
    }

    @JsonIgnore
    private boolean hasBranchAttribute(List<String> branches, BranchId branch) {
        for (String editValues : branches) {
            if (!editValues.contains(branch.getIdString())) continue;
            return true;
        }
        return false;
    }
}

