/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceMessageFilterEndpoint;
import org.eclipse.osee.mim.types.InterfaceMessageToken;

public class InterfaceMessageFilterEndpointImpl
implements InterfaceMessageFilterEndpoint {
    private final BranchId branch;
    private final ArtifactId ConnectionId;
    private final InterfaceMessageApi messageApi;

    public InterfaceMessageFilterEndpointImpl(BranchId branch, ArtifactId connectionId, InterfaceMessageApi interfaceMessageApi) {
        this.branch = branch;
        this.messageApi = interfaceMessageApi;
        this.ConnectionId = connectionId;
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages(long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        Collection<InterfaceMessageToken> messageList = this.messageApi.getAllForConnection(this.branch, this.ConnectionId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        return messageList;
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages(String filter, long pageNum, long pageSize, AttributeTypeToken orderByAttribute) {
        return this.messageApi.getAllForConnectionAndFilter(this.branch, this.ConnectionId, filter);
    }
}

