/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceMessageEndpoint;
import org.eclipse.osee.mim.types.InterfaceMessageToken;

public class InterfaceMessageEndpointImpl
implements InterfaceMessageEndpoint {
    private final BranchId branch;
    private final ArtifactId ConnectionId;
    private final InterfaceMessageApi messageApi;

    public InterfaceMessageEndpointImpl(BranchId branch, ArtifactId connectionId, InterfaceMessageApi interfaceMessageApi) {
        this.branch = branch;
        this.messageApi = interfaceMessageApi;
        this.ConnectionId = connectionId;
    }

    @Override
    public Collection<InterfaceMessageToken> getAllMessages(long pageNum, long pageSize, AttributeTypeToken orderByAttributeTypeId) {
        return this.messageApi.getAllForConnection(this.branch, this.ConnectionId, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
    }

    @Override
    public InterfaceMessageToken getInterfaceMessage(ArtifactId messageId) {
        return this.messageApi.getRelatedToConnection(this.branch, this.ConnectionId, messageId);
    }
}

