/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.console.admin.internal;

import java.util.Dictionary;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osgi.framework.console.CommandInterpreter;

public class ConsoleImpl
implements Console {
    private final CommandInterpreter ci;

    public ConsoleImpl(CommandInterpreter ci) {
        this.ci = ci;
    }

    @Override
    public void write(Object o) {
        this.ci.print((Object)String.valueOf(o));
    }

    @Override
    public void write(String message, Object ... args) {
        this.ci.print((Object)ConsoleImpl.safeFormat(message, args));
    }

    @Override
    public void write(Throwable throwable) {
        if (throwable != null) {
            this.ci.printStackTrace(throwable);
        } else {
            this.ci.print((Object)"Attempted to print null throwable");
        }
    }

    @Override
    public void write(String title, Dictionary<?, ?> dictionary) {
        this.ci.printDictionary(dictionary, title);
    }

    @Override
    public void writeln() {
        this.ci.println();
    }

    private static String safeFormat(String message, Object ... args) {
        String toReturn;
        try {
            toReturn = String.format(message, args);
        }
        catch (RuntimeException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Message could not be formatted:");
            builder.append(message);
            builder.append(" with the following arguments [");
            builder.append(Collections.toString((String)",", (Object[])args));
            builder.append("].  Cause [");
            builder.append(ex.toString());
            builder.append("]");
            toReturn = builder.toString();
        }
        return toReturn;
    }

    @Override
    public Object execute(String command) {
        return this.ci.execute(command);
    }

    @Override
    public void writeln(Object o) {
        this.write(o);
        this.writeln();
    }

    @Override
    public void writeln(String message, Object ... args) {
        this.write(message, args);
        this.writeln();
    }

    @Override
    public void writeln(Throwable throwable) {
        this.write(throwable);
        this.writeln();
    }

    @Override
    public void writeln(String title, Dictionary<?, ?> dictionary) {
        this.write(title, dictionary);
        this.writeln();
    }
}

