/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.BranchCategoryData;
import org.eclipse.osee.orcs.core.ds.BranchCategoryDataFactory;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.TupleDataFactory;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;
import org.eclipse.osee.orcs.core.internal.transaction.ChangeSetBuilder;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;

public class TxDataManager {
    private final ExternalArtifactManager proxyManager;
    private final ArtifactFactory artifactFactory;
    private final RelationManager relationManager;
    private final TupleDataFactory tupleFactory;
    private final BranchCategoryDataFactory categoryFactory;
    private final TxDataLoader loader;

    public TxDataManager(ExternalArtifactManager proxyManager, ArtifactFactory artifactFactory, RelationManager relationManager, TupleDataFactory tupleFactory, BranchCategoryDataFactory categoryFactory, TxDataLoader loader) {
        this.proxyManager = proxyManager;
        this.artifactFactory = artifactFactory;
        this.relationManager = relationManager;
        this.loader = loader;
        this.tupleFactory = tupleFactory;
        this.categoryFactory = categoryFactory;
    }

    public TxData createTxData(OrcsSession session, BranchId branch) {
        GraphData graphData = this.loader.createGraph(session, branch);
        return new TxData(session, graphData);
    }

    public void txCommitSuccess(TxData txData) {
        GraphData graph = txData.getGraph();
        for (Artifact writeable : txData.getAllWriteables()) {
            writeable.setNotDirty();
            RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)writeable);
            for (Relation relation : adjacencies.getDirties()) {
                relation.clearDirty();
            }
        }
        txData.setTxState(TxData.TxState.COMMITTED);
    }

    public void rollbackTx(TxData txData) {
        txData.setTxState(TxData.TxState.COMMIT_FAILED);
    }

    public void startTx(TxData txData) {
        Conditions.checkExpressionFailOnTrue((boolean)txData.isCommitInProgress(), (String)"Commit is already in progress", (Object[])new Object[0]);
        txData.setCommitInProgress(true);
        txData.setTxState(TxData.TxState.COMMIT_STARTED);
    }

    public void endTx(TxData txData) {
        txData.setCommitInProgress(false);
    }

    public Iterable<Artifact> getForWrite(TxData txData, Iterable<? extends ArtifactId> ids) {
        this.checkChangesAllowed(txData);
        LinkedHashSet<ArtifactId> toLoad = new LinkedHashSet<ArtifactId>();
        LinkedHashMap<Long, Artifact> items = new LinkedHashMap<Long, Artifact>();
        for (ArtifactId artifactId : ids) {
            Artifact node = this.findArtifactLocallyForWrite(txData, artifactId);
            if (node == null) {
                toLoad.add(artifactId);
            } else {
                this.checkAndAdd(txData, node);
            }
            items.put(artifactId.getId(), node);
        }
        if (!toLoad.isEmpty()) {
            ResultSet<Artifact> resultSet = this.loader.loadArtifacts(txData.getSession(), txData.getGraph(), toLoad);
            for (Artifact node : resultSet) {
                items.put(node.getId(), node);
                this.checkAndAdd(txData, node);
            }
        }
        return items.values();
    }

    public Artifact getForWrite(TxData txData, ArtifactId artifactId) {
        this.checkChangesAllowed(txData);
        Artifact node = this.findArtifactLocallyForWrite(txData, artifactId);
        if (node == null) {
            if (txData.getGraph().getNode(artifactId) != null) {
                node = (Artifact)txData.getGraph().getNode(artifactId);
            } else {
                ResultSet<Artifact> result = this.loader.loadArtifacts(txData.getSession(), txData.getGraph(), Collections.singleton(artifactId));
                List artifacts = result.getList();
                if (artifacts.size() == 1) {
                    node = (Artifact)artifacts.get(0);
                } else {
                    if (artifacts.isEmpty()) {
                        throw new OseeStateException("Artifact with id %s not found during transaction creation.", new Object[]{artifactId});
                    }
                    throw new OseeStateException("More than one artifact (%s) found with id %s during transaction creation.", new Object[]{artifacts.size(), artifactId});
                }
            }
        }
        this.checkAndAdd(txData, node);
        return node;
    }

    private Artifact findArtifactLocallyForWrite(TxData txData, ArtifactId artifactId) {
        Artifact node = txData.getWriteable(artifactId);
        if (node == null) {
            Artifact source = null;
            if (artifactId instanceof Artifact) {
                source = (Artifact)artifactId;
            } else if (artifactId instanceof ArtifactReadable) {
                ArtifactReadable readable = (ArtifactReadable)artifactId;
                source = this.proxyManager.asInternalArtifact(readable);
            }
            if (this.isFromSameStripe(txData, source) && this.includesDeletedData(source)) {
                node = this.copyArtifactForWrite(txData, source);
            }
        }
        return node;
    }

    private boolean isFromSameStripe(TxData txData, Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        return artifact.getTransaction().equals(txData.getGraph().getTransaction());
    }

    private boolean includesDeletedData(Artifact artifact) {
        boolean result = false;
        if (artifact != null) {
            result = true;
        }
        return result;
    }

    private Artifact copyArtifactForWrite(TxData txData, Artifact source) {
        Artifact artifact = this.artifactFactory.clone(txData.getSession(), source);
        txData.getGraph().addNode(artifact, ((ArtifactData)artifact.getOrcsData()).isExistingVersionUsed());
        this.relationManager.cloneRelations(source, artifact);
        return artifact;
    }

    private Artifact getSourceArtifact(TxData txData, BranchId fromBranch, ArtifactId artifactId) {
        Artifact source = null;
        if (txData.isOnBranch(fromBranch)) {
            source = txData.getWriteable(artifactId);
        }
        if (source == null) {
            ArtifactReadable external;
            Artifact artifactSrc = null;
            if (artifactId instanceof Artifact) {
                Artifact external2 = (Artifact)artifactId;
                if (fromBranch.equals(external2.getBranch())) {
                    artifactSrc = external2;
                }
            } else if (artifactId instanceof ArtifactReadable && fromBranch.equals((external = (ArtifactReadable)artifactId).getBranch())) {
                artifactSrc = this.proxyManager.asInternalArtifact(external);
            }
            if (this.includesDeletedData(artifactSrc)) {
                source = artifactSrc;
            }
        }
        if (source == null) {
            ResultSet<Artifact> loadArtifacts = this.loader.loadArtifact(txData.getSession(), fromBranch, artifactId);
            source = (Artifact)loadArtifacts.getExactlyOne();
        }
        return source;
    }

    private void checkChangesAllowed(TxData txData) {
        String errorMessage = "";
        if (txData.isCommitInProgress() || TxData.TxState.COMMIT_STARTED == txData.getTxState()) {
            errorMessage = "Changes are not allowed - [COMMIT_IN_PROGRESS]";
        }
        if (Strings.isValid((String)errorMessage)) {
            throw new OseeStateException(errorMessage, new Object[0]);
        }
    }

    public void setComment(TxData txData, String comment) {
        this.checkChangesAllowed(txData);
        txData.setComment(comment);
    }

    public void setAuthor(TxData txData, UserToken author) {
        this.checkChangesAllowed(txData);
        txData.setAuthor(author);
    }

    public TupleData introduceTuple(TupleTypeId tupleType, GammaId tupleGamma) {
        return this.tupleFactory.introduceTupleData(tupleType, tupleGamma);
    }

    public GammaId createTuple2(TxData txData, Tuple2Type<?, ?> tupleType, Long e1, Long e2) {
        TupleData tuple = this.tupleFactory.createTuple2Data(tupleType, txData.getBranch(), e1, e2);
        txData.add(tuple);
        return tuple.getVersion().getGammaId();
    }

    public GammaId createTuple3(TxData txData, Tuple3Type<?, ?, ?> tupleType, Long e1, Long e2, Long e3) {
        TupleData tuple = this.tupleFactory.createTuple3Data(tupleType, txData.getBranch(), e1, e2, e3);
        txData.add(tuple);
        return tuple.getVersion().getGammaId();
    }

    public GammaId createTuple4(TxData txData, Tuple4Type<?, ?, ?, ?> tupleType, Long e1, Long e2, Long e3, Long e4) {
        TupleData tuple = this.tupleFactory.createTuple4Data(tupleType, txData.getBranch(), e1, e2, e3, e4);
        txData.add(tuple);
        return tuple.getVersion().getGammaId();
    }

    public GammaId createBranchCategory(TxData txData, BranchCategoryToken category) {
        BranchCategoryData data = this.categoryFactory.createBranchCategoryData(txData.getBranch(), category);
        txData.add(data);
        return data.getVersion().getGammaId();
    }

    public ArtifactReadable createArtifact(TxData txData, ArtifactTypeToken artifactType, String name, String guid) {
        this.checkChangesAllowed(txData);
        Artifact artifact = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), artifactType, guid);
        artifact.setName(name);
        return this.asExternalArtifact(txData, artifact);
    }

    public ArtifactReadable createArtifact(TxData txData, ArtifactTypeToken artifactType, String name, String guid, ApplicabilityId appId) {
        this.checkChangesAllowed(txData);
        Artifact artifact = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), artifactType, guid, appId);
        artifact.setName(name);
        return this.asExternalArtifact(txData, artifact);
    }

    public ArtifactReadable createArtifact(TxData txData, ArtifactTypeToken artifactType, String name, ArtifactId artifactId) {
        this.checkChangesAllowed(txData);
        Artifact artifact = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), artifactType, artifactId);
        artifact.setName(name);
        return this.asExternalArtifact(txData, artifact);
    }

    public ArtifactReadable createArtifact(TxData txData, ArtifactTypeToken artifactType, String name, ArtifactId artifactId, ApplicabilityId appId) {
        this.checkChangesAllowed(txData);
        Artifact artifact = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), artifactType, artifactId, appId);
        artifact.setName(name);
        return this.asExternalArtifact(txData, artifact);
    }

    public ArtifactReadable copyArtifact(TxData txData, BranchId fromBranch, ArtifactId artifactId) {
        this.checkChangesAllowed(txData);
        Artifact source = this.getSourceArtifact(txData, fromBranch, artifactId);
        return this.copyArtifactHelper(txData, source, source.getExistingAttributeTypes());
    }

    public ArtifactReadable copyArtifact(TxData txData, BranchId fromBranch, ArtifactId artifactId, Collection<AttributeTypeToken> attributesToDuplicate) {
        this.checkChangesAllowed(txData);
        Artifact source = this.getSourceArtifact(txData, fromBranch, artifactId);
        return this.copyArtifactHelper(txData, source, attributesToDuplicate);
    }

    private ArtifactReadable copyArtifactHelper(TxData txData, Artifact source, Collection<AttributeTypeToken> attributesToDuplicate) {
        Artifact copy = this.artifactFactory.copyArtifact(txData.getSession(), source, attributesToDuplicate, txData.getBranch());
        return this.asExternalArtifact(txData, copy);
    }

    public ArtifactReadable introduceArtifact(TxData txData, BranchId fromBranch, ArtifactReadable source, ArtifactReadable destination) {
        this.checkChangesAllowed(txData);
        Artifact src = this.getSourceArtifact(txData, fromBranch, (ArtifactId)source);
        Artifact dest = null;
        if (destination == null || destination.isInvalid()) {
            dest = this.artifactFactory.createArtifact(txData.getSession(), txData.getBranch(), src.getArtifactType(), src.getGuid());
            dest.setGraph(this.loader.createGraph(txData.getSession(), txData.getBranch()));
        } else {
            dest = this.getSourceArtifact(txData, fromBranch, (ArtifactId)destination);
        }
        this.artifactFactory.introduceArtifact(txData.getSession(), src, dest, txData.getBranch());
        this.relationManager.introduce(txData.getBranch(), src, dest);
        this.addAdjacencies(txData, dest);
        return this.asExternalArtifact(txData, dest);
    }

    public ArtifactReadable replaceWithVersion(TxData txData, BranchId fromBranch, ArtifactReadable readable, ArtifactReadable destination) {
        return this.introduceArtifact(txData, fromBranch, readable, destination);
    }

    private void addAdjacencies(TxData txData, Artifact dest) {
        GraphData destGraph = dest.getGraph();
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)destGraph.getAdjacencies((ArtifactId)dest);
        GraphData graph = txData.getGraph();
        if (adjacencies != null) {
            for (Relation rel : adjacencies.getAll()) {
                graph.addAdjacencies(rel.getIdForSide(RelationSide.SIDE_B), adjacencies);
            }
        }
    }

    private ArtifactReadable asExternalArtifact(TxData txData, Artifact artifact) {
        this.checkAndAdd(txData, artifact);
        ArtifactReadable readable = txData.getReadable((ArtifactId)artifact);
        if (readable == null) {
            readable = this.proxyManager.asExternalArtifact(txData.getSession(), artifact);
            txData.add(readable);
        }
        return readable;
    }

    private void checkAndAdd(TxData txData, Artifact artifact) {
        this.checkChangesAllowed(txData);
        Artifact oldArtifact = txData.add(artifact);
        boolean isDifferent = oldArtifact != null && oldArtifact.notEqual((Id)artifact);
        Conditions.checkExpressionFailOnTrue((boolean)isDifferent, (String)"Another instance of writeable detected - writeable tracking would be inconsistent", (Object[])new Object[0]);
        txData.getGraph().addNode(artifact, ((ArtifactData)artifact.getOrcsData()).isExistingVersionUsed());
    }

    public void deleteArtifact(TxData txData, ArtifactId sourceArtifact) {
        Artifact asArtifact = this.getForWrite(txData, sourceArtifact);
        this.relationManager.unrelateFromAll(txData.getSession(), asArtifact);
        asArtifact.delete();
    }

    public void addChild(TxData txData, ArtifactId parent, ArtifactId child) {
        OrcsSession session = txData.getSession();
        Artifact asArtifact = this.getForWrite(txData, parent);
        this.relationManager.addChild(session, asArtifact, this.getForWrite(txData, child));
    }

    public void relate(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, type, asArtifactB, txData);
    }

    public void relate(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB, String rationale) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, type, asArtifactB, rationale);
    }

    public void relate(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB, RelationSorter sortType) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, type, asArtifactB, sortType);
    }

    public void relate(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB, String rationale, RelationSorter sortType) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, type, asArtifactB, rationale, sortType);
    }

    public void relate(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB, ArtifactId relatedArtifact, int relOrder, RelationSorter sortType) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.relate(txData.getSession(), asArtifactA, type, asArtifactB, "", sortType, relOrder, relatedArtifact, null);
    }

    public void setRelations(TxData txData, ArtifactId artA, RelationTypeToken type, Iterable<? extends ArtifactId> artBs) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        LinkedHashSet asArtifactBs = Sets.newLinkedHashSet(this.getForWrite(txData, artBs));
        OrcsSession session = txData.getSession();
        ResultSet related = this.relationManager.getRelated(session, type, asArtifactA, RelationSide.SIDE_A);
        LinkedHashSet relatedArtBs = Sets.newLinkedHashSet(this.getForWrite(txData, (Iterable<? extends ArtifactId>)related));
        for (Artifact asArtifactB : Sets.difference((Set)asArtifactBs, (Set)relatedArtBs)) {
            this.relationManager.relate(session, asArtifactA, type, asArtifactB);
        }
        for (Artifact asArtifactB : Sets.difference((Set)relatedArtBs, (Set)asArtifactBs)) {
            this.relationManager.unrelate(session, asArtifactA, type, asArtifactB);
        }
    }

    public void setRelationsAndOrder(TxData txData, ArtifactId artA, RelationTypeSide relationSide, List<? extends ArtifactId> artBs) {
        this.setRelations(txData, artA, (RelationTypeToken)relationSide, artBs);
        Artifact asArtifactA = this.getForWrite(txData, artA);
        LinkedList<Artifact> asArtifactBs = new LinkedList<Artifact>();
        for (ArtifactId artifactId : artBs) {
            asArtifactBs.add(this.getForWrite(txData, artifactId));
        }
        this.relationManager.order(asArtifactA, (RelationTypeToken)relationSide, relationSide.getSide(), asArtifactBs);
    }

    public void setRationale(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB, String rationale) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.setRationale(asArtifactA, type, asArtifactB, rationale);
    }

    public void unrelate(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        Relation relation = this.relationManager.unrelate(txData.getSession(), asArtifactA, type, asArtifactB);
        if (relation != null) {
            txData.addRelation(relation);
        }
    }

    public void unrelateFromAll(TxData txData, ArtifactId artA) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        this.relationManager.unrelateFromAll(txData.getSession(), asArtifactA);
    }

    public void unrelateFromAll(TxData txData, RelationTypeToken type, ArtifactId artA, RelationSide side) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        this.relationManager.unrelateFromAll(txData.getSession(), type, asArtifactA, side);
    }

    public void setRelationApplicabilityId(TxData txData, ArtifactId artA, RelationTypeToken type, ArtifactId artB, ApplicabilityId applicId) {
        Artifact asArtifactA = this.getForWrite(txData, artA);
        Artifact asArtifactB = this.getForWrite(txData, artB);
        this.relationManager.setApplicabilityId(asArtifactA, type, asArtifactB, applicId);
    }

    public TransactionData createChangeData(TxData txData) {
        GraphData graph = txData.getGraph();
        ChangeSetBuilder builder = new ChangeSetBuilder();
        for (Artifact artifact : txData.getAllWriteables()) {
            artifact.accept(builder);
            this.relationManager.accept(graph, artifact, builder);
        }
        builder.handleOtherData(txData);
        OrcsChangeSet changeSet = builder.getChangeSet();
        return new TransactionDataImpl(txData.getBranch(), txData.getAuthor(), txData.getComment(), changeSet);
    }

    public void setApplicabilityId(TxData txData, ArtifactId artId, ApplicabilityId applicId) {
        Artifact asArtifactA = this.getForWrite(txData, artId);
        ((ArtifactData)asArtifactA.getOrcsData()).setApplicabilityId(applicId);
    }

    private static final class TransactionDataImpl
    implements TransactionData {
        private final BranchId branch;
        private final UserToken author;
        private final String comment;
        private final OrcsChangeSet changeSet;

        public TransactionDataImpl(BranchId branch, UserToken author, String comment, OrcsChangeSet changeSet) {
            this.branch = branch;
            this.author = author;
            this.comment = comment;
            this.changeSet = changeSet;
        }

        @Override
        public BranchId getBranch() {
            return this.branch;
        }

        @Override
        public UserToken getAuthor() {
            return this.author;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public OrcsChangeSet getChangeSet() {
            return this.changeSet;
        }

        public String toString() {
            return "TransactionDataImpl [branch=" + this.branch + ", author=" + this.author + ", comment=" + this.comment + ", changeSet=" + this.changeSet + "]";
        }
    }

    public static interface TxDataLoader {
        public GraphData createGraph(OrcsSession var1, BranchId var2);

        public ResultSet<Artifact> loadArtifact(OrcsSession var1, BranchId var2, ArtifactId var3);

        public ResultSet<Artifact> loadArtifacts(OrcsSession var1, GraphData var2, Collection<ArtifactId> var3);
    }
}

