/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.AtsWorkPackageEndpointApi;
import org.eclipse.osee.ats.api.ev.JaxWorkPackageData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.ColorTeams;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsWorkPackageEndpointImpl
implements AtsWorkPackageEndpointApi {
    private static final String COLOR_TEAM_KEY = "colorTeam";
    private final AtsApi atsApi;

    public AtsWorkPackageEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @GET
    @Path(value="{workPackageId}/workitem")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getWorkItems(@PathParam(value="workPackageId") long workPackageId) {
        ArtifactReadable workPackageArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(Long.valueOf(workPackageId));
        if (workPackageArt == null) {
            throw new OseeArgumentException("Work Package with id [%s] Not Found", new Object[]{workPackageId});
        }
        List arts = this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.WorkPackageReference, workPackageArt.getIdString(), new QueryOption[0]).getResults().getList();
        return arts;
    }

    @PUT
    @Path(value="{workPackageId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData setWorkPackage(@PathParam(value="workPackageId") long workPackageId, JaxWorkPackageData workPackageData) {
        AtsUser asUser;
        XResultData rd = new XResultData();
        ArtifactReadable workPackageArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(Long.valueOf(workPackageId));
        if (workPackageArt == null) {
            rd.errorf("Work Package with id [%s] Not Found", new Object[]{workPackageId});
        }
        if ((asUser = this.atsApi.getUserService().getUserByUserId(workPackageData.getAsUserId())) == null) {
            rd.errorf("Author with id [%s] Not Found", new Object[]{workPackageData.getAsUserId()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Set Work Package", asUser);
        for (Long workItemId : workPackageData.getWorkItemIds()) {
            IAtsWorkItem workItem = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(new Long[]{workItemId}).getResults().getAtMostOneOrDefault((Object)IAtsWorkItem.SENTINEL);
            if (workItem.isInvalid()) {
                rd.errorf("Work Item with id [%s] Not Found", new Object[]{workItemId});
            }
            if (!workItem.isTask() && !workItem.isTeamWorkflow()) {
                rd.errorf("Work Packages can only be set on Team Workflow or Task, not [%s]", new Object[]{workItem.getArtifactTypeName()});
            }
            changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)workPackageArt);
            rd.getIds().add(workItemId.toString());
        }
        if (!changes.isEmpty()) {
            TransactionToken transactionId = changes.execute();
            rd.setTxId(transactionId.getIdString());
        }
        return rd;
    }

    @GET
    @Path(value="colorteam")
    @Produces(value={"application/json"})
    public ColorTeams getColorTeams() {
        String colorTeamStr = this.atsApi.getConfigValue(COLOR_TEAM_KEY);
        ColorTeams teams = null;
        teams = Strings.isValid((String)colorTeamStr) ? (ColorTeams)this.atsApi.jaxRsApi().readValue(colorTeamStr, ColorTeams.class) : new ColorTeams();
        return teams;
    }

    @DELETE
    @Path(value="{workPackageId}/workitem")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData deleteWorkPackageItems(@PathParam(value="workPackageId") long workPackageId, JaxWorkPackageData workPackageData) {
        XResultData rd = new XResultData();
        AtsUser asUser = this.atsApi.getUserService().getUserByUserId(workPackageData.getAsUserId());
        if (asUser == null) {
            rd.errorf("Author with id [%s] Not Found", new Object[]{workPackageData.getAsUserId()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Remove Work Package", asUser);
        for (Long workItemId : workPackageData.getWorkItemIds()) {
            IAtsWorkItem workItem = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(new Long[]{workItemId}).getResults().getAtMostOneOrDefault((Object)IAtsWorkItem.SENTINEL);
            if (workItem.isInvalid()) {
                rd.errorf("Work Item with id [%s] Not Found", new Object[]{workItemId});
            }
            if (this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, null) == null) continue;
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference);
            rd.getIds().add(workItemId.toString());
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return rd;
    }
}

