/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.CiItemData;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.CiTestPoint;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@Path(value="ci")
public class ContinuousIntegrationResource {
    private final DispoApi dispoApi;

    public ContinuousIntegrationResource(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    @Path(value="annotations")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public HashMap<String, List<DispoAnnotationData>> getAllDispoAnnotations(CiSetData setData) {
        HashMap<String, List<DispoAnnotationData>> allDispoAnnotations = new HashMap<String, List<DispoAnnotationData>>();
        if (setData != null) {
            List<DispoItem> dispoItems = this.dispoApi.getDispoItems(BranchId.valueOf((String)setData.getBranchId()), setData.getDispoSetId(), false);
            for (DispoItem item : dispoItems) {
                allDispoAnnotations.put(item.getName(), item.getAnnotationsList());
            }
        }
        return allDispoAnnotations;
    }

    @Path(value="{item}/annotation")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<DispoAnnotationData> getAllDispoAnnotationsPerItem(CiSetData setData, @PathParam(value="item") String item) {
        BranchId branch;
        String itemId;
        if (setData != null && (itemId = this.dispoApi.getDispoItemId(branch = BranchId.valueOf((String)setData.getBranchId()), setData.getDispoSetId(), item)) != null && !itemId.isEmpty()) {
            return this.dispoApi.getDispoAnnotations(branch, itemId);
        }
        return null;
    }

    @GET
    @Path(value="sets")
    @Produces(value={"application/json"})
    public List<CiSetData> getAllCiSets() {
        return this.dispoApi.getAllCiSets();
    }

    /*
     * Unable to fully structure code
     */
    @Path(value="annotate")
    @POST
    @Consumes(value={"application/json"})
    public Response createDispoAnnotation(CiItemData data, @QueryParam(value="userName") String userName) {
        var3_3 = null;
        var4_5 = null;
        try {
            block31: {
                block32: {
                    block30: {
                        response = Response.status((Response.Status)Response.Status.OK).build();
                        if (data == null) break block32;
                        branch = BranchId.valueOf((String)data.getSetData().getBranchId());
                        itemId = this.dispoApi.getDispoItemId(branch, data.getSetData().getDispoSetId(), data.getScriptName());
                        if (Strings.isInValid((String)itemId)) {
                            this.dispoApi.createDispoItem(branch, data, userName);
                            itemId = this.dispoApi.getDispoItemId(branch, data.getSetData().getDispoSetId(), data.getScriptName());
                        }
                        if (!Strings.isValid((String)itemId)) ** break block33
                        this.updateDiscrepencies(data, branch, itemId, userName);
                        this.dispoApi.deleteAllDispoAnnotation(branch, itemId, userName, true);
                        var8_14 = null;
                        var9_17 = null;
                        res2 = this.createAndUpdateAnnotation(data, userName, response, branch, itemId);
                        v0 = res2;
                        if (res2 == null) break block30;
                        res2.close();
                    }
                    return v0;
                    {
                        catch (Throwable var8_15) {
                            try {
                                if (res2 != null) {
                                    res2.close();
                                }
                                throw var8_15;
                            }
                            catch (Throwable var9_18) {
                                if (var8_14 == null) {
                                    var8_14 = var9_18;
                                } else if (var8_14 != var9_18) {
                                    var8_14.addSuppressed(var9_18);
                                }
                                throw var8_14;
                            }
                        }
                    }
                }
                var6_9 = null;
                var7_12 = null;
                res3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                v1 = res3;
                if (res3 == null) break block31;
                res3.close();
            }
            return v1;
            {
                catch (Throwable var6_10) {
                    try {
                        if (res3 != null) {
                            res3.close();
                        }
                        throw var6_10;
                    }
                    catch (Throwable var7_13) {
                        if (var6_9 == null) {
                            var6_9 = var7_13;
                        } else if (var6_9 != var7_13) {
                            var6_9.addSuppressed(var7_13);
                        }
                        throw var6_9;
                    }
                }
            }
            {
                v2 = response;
            }
            return v2;
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
    }

    private void updateDiscrepencies(CiItemData data, BranchId branch, String itemId, String userName) {
        CiTestPoint testPoints = data.getTestPoints();
        DispoItem item = this.dispoApi.getDispoItemById(branch, itemId);
        DispoItemData itemData = DispoUtil.itemArtToItemData(item, true);
        String asRanges = itemData.getDiscrepanciesAsRanges();
        if (!testPoints.getFail().equals(asRanges)) {
            this.removePassing(branch, itemId, userName, testPoints, item);
            this.addFailing(branch, itemId, userName, testPoints, item);
        }
    }

    private void addFailing(BranchId branch, String itemId, String userName, CiTestPoint testPoints, DispoItem item) {
        List<Integer> ranges = DispoUtil.splitDiscrepancyLocations(testPoints.getFail());
        List<String> discrepToAdd = DispoUtil.findMissingDiscrepancyLocs(ranges, item);
        ArrayList<Discrepancy> discrepancies = new ArrayList<Discrepancy>();
        for (String toAdd : discrepToAdd) {
            Discrepancy discrepancy = new Discrepancy();
            discrepancy.setLocation(toAdd);
            discrepancies.add(discrepancy);
        }
        this.dispoApi.createDispoDiscrepancies(branch, itemId, discrepancies, userName);
        this.dispoApi.editDispoDiscrepancies(branch, itemId, discrepancies, userName);
    }

    private void removePassing(BranchId branch, String itemId, String userName, CiTestPoint testPoints, DispoItem item) {
        if (testPoints.getFail().equals("")) {
            for (Discrepancy discrepancy : item.getDiscrepanciesList().values()) {
                this.dispoApi.deleteDispoDiscrepancy(branch, itemId, discrepancy.getId(), userName);
            }
        } else {
            List<Integer> ranges = DispoUtil.splitDiscrepancyLocations(testPoints.getPass());
            List<String> discrepToRemove = DispoUtil.findDiscrepancyLocsToRemove(ranges, item);
            for (String toRemove : discrepToRemove) {
                this.dispoApi.deleteDispoDiscrepancy(branch, itemId, toRemove, userName);
            }
        }
    }

    private Response createAndUpdateAnnotation(CiItemData data, String userName, Response response, BranchId branchId, String itemId) {
        for (DispoAnnotationData annotation : data.getAnnotations()) {
            Throwable throwable;
            DispoAnnotationData temp = new DispoAnnotationData();
            String createdAnnotationId = this.dispoApi.createDispoAnnotation(branchId, itemId, temp, userName, true);
            if (!createdAnnotationId.isEmpty()) {
                Response createAnnId32;
                Throwable throwable2 = null;
                throwable = null;
                try {
                    createAnnId32 = Response.status((Response.Status)Response.Status.OK).build();
                    try {
                        response = createAnnId32;
                    }
                    finally {
                        if (createAnnId32 != null) {
                            createAnnId32.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                this.initTempAnnotationData(annotation, temp);
                boolean wasEdited = this.dispoApi.editDispoAnnotation(branchId, itemId, createdAnnotationId, temp, userName, true);
                if (wasEdited) {
                    throwable = null;
                    createAnnId32 = null;
                    try (Response edited = Response.status((Response.Status)Response.Status.OK).build();){
                        response = edited;
                        continue;
                    }
                    catch (Throwable createAnnId32) {
                        if (throwable == null) {
                            throwable = createAnnId32;
                        } else if (throwable != createAnnId32) {
                            throwable.addSuppressed(createAnnId32);
                        }
                        throw throwable;
                    }
                }
                throwable = null;
                createAnnId32 = null;
                try (Response notModified = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();){
                    response = notModified;
                    break;
                }
                catch (Throwable createAnnId32) {
                    if (throwable == null) {
                        throwable = createAnnId32;
                    } else if (throwable != createAnnId32) {
                        throwable.addSuppressed(createAnnId32);
                    }
                    throw throwable;
                }
            }
            Throwable throwable4 = null;
            throwable = null;
            try (Response notAcceptable = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();){
                response = notAcceptable;
                break;
            }
            catch (Throwable throwable5) {
                if (throwable4 == null) {
                    throwable4 = throwable5;
                } else if (throwable4 != throwable5) {
                    throwable4.addSuppressed(throwable5);
                }
                throw throwable4;
            }
        }
        return response;
    }

    private void initTempAnnotationData(DispoAnnotationData annotation, DispoAnnotationData temp) {
        temp.setLocationRefs(annotation.getLocationRefs());
        temp.setResolution(annotation.getResolution());
        temp.setResolutionType(annotation.getResolutionType());
        temp.setLastResolution(annotation.getLastResolution());
        temp.setCustomerNotes(annotation.getCustomerNotes());
        temp.setDeveloperNotes(annotation.getDeveloperNotes());
    }
}

