/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing.templatemanager;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.eclipse.osee.define.api.publishing.templatemanager.RendererOptions;
import org.eclipse.osee.define.api.publishing.templatemanager.TemplateContent;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingTemplate
implements ToMessage {
    public static final PublishingTemplate SENTINEL;
    private String identifier;
    private String name;
    private RendererOptions rendererOptions;
    private String style;
    private TemplateContent templateContent;

    static {
        PublishingTemplate sentinelPublishingTemplate = new PublishingTemplate();
        sentinelPublishingTemplate.sentinel();
        SENTINEL = sentinelPublishingTemplate;
    }

    public PublishingTemplate() {
        this.identifier = null;
        this.name = null;
        this.rendererOptions = null;
        this.style = null;
        this.templateContent = null;
    }

    public PublishingTemplate(String identifier, String name, RendererOptions rendererOptions, String style, TemplateContent templateContent) {
        this.identifier = Objects.requireNonNull(identifier, "PublishingTemplate::new, parameter \"identifier\" cannot be null.");
        this.name = Objects.requireNonNull(name, "PublishingTemplate::new, parameter \"name\" cannot be null.");
        this.rendererOptions = Objects.requireNonNull(rendererOptions, "PublishingTemplate::new, parameter \"rendererOptions\" cannot be null.");
        this.style = Objects.requireNonNull(style, "PublishingTemplate::new, parameter \"style\" cannot be null.");
        this.templateContent = Objects.requireNonNull(templateContent, "PublishingTemplate::new, parameter \"templateContent\" cannot be null.");
    }

    public void defaults() {
        if (Objects.isNull(this.identifier)) {
            this.sentinel();
            return;
        }
        if (Objects.isNull(this.name)) {
            this.sentinel();
            return;
        }
        if (Objects.isNull(this.rendererOptions)) {
            this.rendererOptions = new RendererOptions();
        }
        this.rendererOptions.defaults();
        if (Objects.isNull(this.style)) {
            this.style = "";
        }
        if (Objects.isNull(this.templateContent)) {
            this.templateContent = new TemplateContent();
        }
        this.templateContent.defaults();
    }

    public String getIdentifier() {
        if (Objects.isNull(this.identifier)) {
            throw new IllegalStateException("PublishingTemplate::getIdentifier, the member \"identifier\" has not been set.");
        }
        return this.identifier;
    }

    public String getName() {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("PublishingTemplate::getName, the member \"name\" has not been set.");
        }
        return this.name;
    }

    public RendererOptions getRendererOptions() {
        if (Objects.isNull(this.rendererOptions)) {
            throw new IllegalStateException("PublishingTemplate::getRendererOptions, the member \"rendererOptions\" has not been set.");
        }
        return this.rendererOptions;
    }

    public String getStyle() {
        if (Objects.isNull(this.style)) {
            throw new IllegalStateException("PublishingTemplate::getStyle, the member \"style\" has not been set.");
        }
        return this.style;
    }

    public TemplateContent getTemplateContent() {
        if (Objects.isNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::getTemplateContent, the member \"templateContent\" has not been set.");
        }
        return this.templateContent;
    }

    @JsonIgnore
    public boolean isSentinel() {
        return this == SENTINEL || "SENTINEL".equals(this.identifier) || "SENTINEL".equals(this.name);
    }

    public boolean isValid() {
        return Objects.nonNull(this.identifier) && !this.identifier.isBlank() && Objects.nonNull(this.name) && !this.name.isBlank() && Objects.nonNull(this.rendererOptions) && this.rendererOptions.isValid() && Objects.nonNull(this.style) && Objects.nonNull(this.templateContent) && this.templateContent.isValid();
    }

    private void sentinel() {
        this.identifier = "SENTINEL";
        this.name = "SENTINEL";
        this.rendererOptions = new RendererOptions();
        this.rendererOptions.defaults();
        this.style = "";
        this.templateContent = new TemplateContent();
        this.templateContent.defaults();
    }

    public void setIdentifier(String identifier) {
        if (Objects.nonNull(this.identifier)) {
            throw new IllegalStateException("PublishingTemplate::setIdentifier, member \"identifier\" has already been set.");
        }
        this.identifier = Objects.requireNonNull(identifier, "PublishingTemplate::new, parameter \"identifier\" cannot be null.");
    }

    public void setName(String name) {
        if (Objects.nonNull(this.name)) {
            throw new IllegalStateException("PublishingTemplate::setName, member \"name\" has already been set.");
        }
        this.name = Objects.requireNonNull(name, "PublishingTemplate::new, parameter \"name\" cannot be null.");
    }

    public void setRendererOptions(RendererOptions rendererOptions) {
        if (Objects.nonNull(this.rendererOptions)) {
            throw new IllegalStateException("PublishingTemplate::setRendererOptions, member \"rendererOptions\" has already been set.");
        }
        this.rendererOptions = Objects.requireNonNull(rendererOptions, "PublishingTemplate::new, parameter \"rendererOptions\" cannot be null.");
    }

    public void setStyle(String style) {
        if (Objects.nonNull(this.style)) {
            throw new IllegalStateException("PublishingTemplate::setStyle, member \"style\" has already been set.");
        }
        this.style = Objects.requireNonNull(style, "PublishingTemplate::new, parameter \"style\" cannot be null.");
    }

    public void setTemplateContent(TemplateContent templateContent) {
        if (Objects.nonNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::setTemplateContent, member \"templateContent\" has already been set.");
        }
        this.templateContent = Objects.requireNonNull(templateContent, "PublishingTemplate::new, parameter \"templateContent\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Publishing Template").indentInc().segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).segment((CharSequence)"Style", (Object)this.style).toMessage((ToMessage)this.rendererOptions).toMessage((ToMessage)this.templateContent).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

