/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest.denizens;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataType;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class NativeDataTypeKeyFactory {
    private static EnumMap<NativeDataType, NativeDataTypeKey> nonEnumeratedKeyCache = new EnumMap(NativeDataType.class);
    private final Map<Object, NativeDataTypeKey> enumeratedKeyCache = new HashMap<Object, NativeDataTypeKey>();

    static {
        Stream.of(NativeDataType.values()).filter(member -> !member.equals((Object)NativeDataType.ENUMERATED)).forEach(member -> {
            NativeDataTypeKey nativeDataTypeKey = nonEnumeratedKeyCache.put((NativeDataType)((Object)member), new NativeDataTypeKey((NativeDataType)((Object)member)));
        });
    }

    private NativeDataTypeKey createOrGetEnumeratedKey(AttributeTypeToken attributeTypeToken) {
        Long key = attributeTypeToken.getId();
        NativeDataTypeKey value = this.enumeratedKeyCache.get(key);
        if (value == null) {
            value = new NativeDataTypeKey(attributeTypeToken);
            this.enumeratedKeyCache.put(key, value);
        }
        return value;
    }

    public NativeDataTypeKey createOrGetKey(AttributeTypeToken attributeTypeToken) {
        NativeDataType nativeDataType = NativeDataType.classifyNativeDataType(attributeTypeToken);
        return nativeDataType == NativeDataType.ENUMERATED ? this.createOrGetEnumeratedKey(attributeTypeToken) : nonEnumeratedKeyCache.get((Object)nativeDataType);
    }
}

