/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerLocal;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;

public class ArtifactTopicEventHandler
implements EventHandlerLocal<IArtifactTopicEventListener, ArtifactTopicEvent> {
    @Override
    public void handle(IArtifactTopicEventListener listener, Sender sender, ArtifactTopicEvent event) {
        EventUtil.eventLog((String)String.format("IEM: processArtsAndRels [%s]", new Object[]{event}), (Object[])new Object[0]);
        List<? extends ITopicEventFilter> filters = listener.getTopicEventFilters();
        if (filters != null) {
            for (ITopicEventFilter iTopicEventFilter : filters) {
                if (!iTopicEventFilter.isMatch(event.getBranch())) {
                    return;
                }
                if (event.getArtifacts().isEmpty() && event.getRelations().isEmpty()) continue;
                boolean matchFound = false;
                if (!event.getArtifacts().isEmpty() && iTopicEventFilter.isMatchArtifacts(event.getArtifacts())) {
                    matchFound = true;
                }
                if (!matchFound && !event.getRelations().isEmpty() && iTopicEventFilter.isMatchRelationArtifacts(event.getRelations())) {
                    matchFound = true;
                }
                if (matchFound) continue;
                return;
            }
        }
        listener.handleArtifactTopicEvent(event, sender);
    }

    @Override
    public void send(Transport transport, Sender sender, ArtifactTopicEvent event) {
        if (transport.isDispatchToLocalAllowed(sender)) {
            transport.sendLocal(sender, event);
        }
        if (sender.isLocal() && !event.isReloadEvent()) {
            transport.sendRemote((RemoteEvent)FrameworkEventUtil.getRemotePersistTopicEvent(event));
        }
    }
}

