/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.utils;

import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.DataStore;
import org.eclipse.osee.framework.skynet.core.attribute.utils.BinaryContentUtils;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;

public class AttributeResourceProcessor {
    private final Attribute<?> attribute;

    public AttributeResourceProcessor(Attribute<?> attribute) {
        this.attribute = attribute;
    }

    public String createStorageName() {
        return BinaryContentUtils.getStorageName(this.attribute);
    }

    private ResourcesEndpoint getResourcesEndpoint() {
        OseeClient client = ServiceUtil.getOseeClient();
        return client.getResourcesEndpoint();
    }

    public void saveResource(GammaId gammaId, String name, DataStore dataStore) {
        ResourcesEndpoint endpoint = this.getResourcesEndpoint();
        InputStream inputStream = null;
        try {
            inputStream = dataStore.getInputStream();
            String resourceId = gammaId.getIdString();
            boolean overwriteAllowed = false;
            boolean compressOnSave = false;
            StringBuilder builder = new StringBuilder();
            builder.append(name);
            String extension = dataStore.getExtension();
            if (Strings.isValid((String)extension)) {
                builder.append(".");
                builder.append(extension);
            }
            String resourceName = builder.toString();
            Throwable throwable = null;
            Object var13_14 = null;
            try (Response response = endpoint.saveResource(inputStream, "attr", resourceId, resourceName, overwriteAllowed, compressOnSave);){
                String location = BinaryContentUtils.getAttributeLocation(response);
                dataStore.setLocator(location);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Lib.close((AutoCloseable)inputStream);
        }
    }

    public void acquire(DataStore dataStore) {
        block16: {
            ResourcesEndpoint endpoint = this.getResourcesEndpoint();
            String path = BinaryContentUtils.asResourcePath(dataStore.getLocator());
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Response response = endpoint.getResource(path, false, false);){
                    if (Response.Status.OK.getStatusCode() != response.getStatus()) break block16;
                    InputStream inputStream = null;
                    try {
                        String contentDisposition;
                        inputStream = (InputStream)response.readEntity(InputStream.class);
                        byte[] data = Lib.inputStreamToBytes((InputStream)inputStream);
                        String extension = "";
                        String contentType = "text/plain";
                        String encoding = "UTF-8";
                        MediaType mediaType = response.getMediaType();
                        if (mediaType != null && (contentType = mediaType.getType()).contains("zip")) {
                            encoding = "ISO-8859-1";
                            extension = "zip";
                        }
                        if (!Strings.isValid((String)extension) && Strings.isValid((String)(contentDisposition = response.getHeaderString("Content-Disposition")))) {
                            int index = contentDisposition.indexOf("filename=");
                            int parseAt = index + "filename=".length();
                            if (index > 0 && contentDisposition.length() > parseAt) {
                                String resourceName = contentDisposition.substring(parseAt);
                                extension = Lib.getExtension((String)resourceName);
                            }
                        }
                        dataStore.setContent(data, extension, contentType, encoding);
                    }
                    catch (Throwable throwable2) {
                        Lib.close(inputStream);
                        throw throwable2;
                    }
                    Lib.close((AutoCloseable)inputStream);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
    }

    public void purge(DataStore dataStore) {
        ResourcesEndpoint endpoint = this.getResourcesEndpoint();
        String path = BinaryContentUtils.asResourcePath(dataStore.getLocator());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Response response = endpoint.deleteResource(path);){
            if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                dataStore.clear();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

