/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.factory;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactFactory;
import org.eclipse.osee.framework.skynet.core.artifact.factory.DefaultArtifactFactory;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public final class ArtifactFactoryManager {
    private static final String ARTIFACT_FACTORY_EXTENSION = "ArtifactFactory";
    private static final String EXTENSION_ID = "org.eclipse.osee.framework.skynet.core.ArtifactFactory";
    private static final String CLASSNAME_ATTRIBUTE = "classname";
    private static final ExtensionDefinedObjects<ArtifactFactory> extensionDefinedObjects = new ExtensionDefinedObjects("org.eclipse.osee.framework.skynet.core.ArtifactFactory", "ArtifactFactory", "classname");
    private static final DefaultArtifactFactory defaultArtifactFactory = new DefaultArtifactFactory();
    private static Set<ArtifactTypeId> eternalArtifactTypes = null;

    public ArtifactFactory getFactory(ArtifactTypeToken artifactType) {
        Exception savedEx = null;
        ArtifactFactory responsibleFactory = null;
        for (ArtifactFactory factory : ArtifactFactoryManager.getFactories()) {
            try {
                if (!factory.isResponsibleFor(artifactType)) continue;
                if (responsibleFactory == null) {
                    responsibleFactory = factory;
                    continue;
                }
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Multiple ArtifactFactories [%s] [%s]responsible for same artifact type [%s].  Defaulting to DefaultArtifactFactory.", (Object[])new Object[]{responsibleFactory, factory, artifactType});
                return this.getDefaultArtifactFactory();
            }
            catch (Exception ex) {
                savedEx = ex;
            }
        }
        if (responsibleFactory != null) {
            return responsibleFactory;
        }
        if (savedEx != null) {
            OseeLog.log(this.getClass(), (Level)Level.SEVERE, savedEx);
        }
        return this.getDefaultArtifactFactory();
    }

    public static synchronized Collection<ArtifactTypeId> getEternalArtifactTypes() {
        if (eternalArtifactTypes == null) {
            eternalArtifactTypes = new HashSet<ArtifactTypeId>();
            for (ArtifactFactory factory : ArtifactFactoryManager.getFactories()) {
                eternalArtifactTypes.addAll(factory.getEternalArtifactTypes());
            }
        }
        return eternalArtifactTypes;
    }

    private ArtifactFactory getDefaultArtifactFactory() {
        return defaultArtifactFactory;
    }

    private static synchronized List<ArtifactFactory> getFactories() {
        return extensionDefinedObjects.getObjects();
    }
}

