/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.operations;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.ote.define.internal.Activator;

public abstract class AbstractRemoteResourceRequestTemplate {
    private static final int CONNECTION_TIMEOUT = 120000;
    private static final int CONNECTION_READ_TIMEOUT = 10000;
    private IFile remoteFile;
    private final String tempFolderName;
    private final String remoteRequestUrl;

    public AbstractRemoteResourceRequestTemplate(String tempFolderName, String remoteRequestUrl) {
        this.tempFolderName = tempFolderName;
        this.remoteRequestUrl = remoteRequestUrl;
        this.remoteFile = null;
        this.createTemporaryDirectory();
    }

    private void createTemporaryDirectory() {
        try {
            IProject project = OseeData.getProject();
            IFolder folder = project.getFolder(String.valueOf(this.tempFolderName) + File.separator);
            if (folder != null && !folder.exists()) {
                ContainerCreator containerCreator = new ContainerCreator(folder.getWorkspace(), folder.getFullPath());
                containerCreator.createContainer((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException ex1) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)ex1.toString(), (Throwable)ex1);
        }
    }

    private boolean isLocalFileAvailable(IFile file) {
        boolean found = false;
        if (file != null) {
            try {
                IFileStore store = EFS.getStore((URI)file.getLocationURI());
                found = store.fetchInfo().exists();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error retrieving file system. ", (Throwable)ex);
            }
        }
        return found;
    }

    public IFile getResults() {
        return this.remoteFile;
    }

    protected HttpURLConnection setupConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(120000);
        connection.setReadTimeout(10000);
        return connection;
    }

    public int getTotalWork() throws Exception {
        return !this.isLocalFileAvailable(this.getLocalStorageIFile()) ? 4 : 1;
    }

    private boolean isRemoteRequestNeeded() throws Exception {
        return !this.isLocalFileAvailable(this.getLocalStorageIFile());
    }

    /*
     * Unable to fully structure code
     */
    public void execute(IProgressMonitor monitor) throws Exception {
        if (this.isRemoteRequestNeeded()) {
            connection = null;
            try {
                monitor.setTaskName(String.format("Requesting Resource: [%s]", new Object[]{this.getRemoteFileName()}));
                connection = this.setupConnection(new URL(this.remoteRequestUrl));
                connection.connect();
                monitor.worked(1);
                if (monitor.isCanceled()) ** GOTO lbl17
                this.remoteFile = this.handleTransfer(monitor, connection);
                monitor.worked(1);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        } else {
            this.remoteFile = this.getLocalStorageIFile();
        }
lbl17:
        // 3 sources

        monitor.worked(1);
    }

    protected IFile getLocalStorageIFile() throws Exception {
        return OseeData.getIFile((String)this.getLocalStorageName());
    }

    protected String getRemoteRequestUrl() {
        return this.remoteRequestUrl;
    }

    protected String getTempFolderName() {
        return this.tempFolderName;
    }

    protected abstract String getLocalStorageName() throws Exception;

    protected abstract String getRemoteFileName();

    protected abstract IFile handleTransfer(IProgressMonitor var1, HttpURLConnection var2) throws Exception;
}

