/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.MessageService;
import org.eclipse.osee.framework.messaging.NodeInfo;
import org.eclipse.osee.framework.messaging.internal.MessageServiceImpl;
import org.eclipse.osee.framework.messaging.internal.activemq.ConnectionNodeFactoryImpl;

public class MessageServiceProxy
implements MessageService {
    private MessageServiceImpl messageService;
    private ExecutorService executor;

    public void start() {
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        String sourceId = Integer.toString(this.hashCode());
        ConnectionNodeFactoryImpl factory = new ConnectionNodeFactoryImpl("1.0", sourceId, this.executor);
        this.messageService = new MessageServiceImpl(factory);
    }

    public void stop() {
        this.executor.shutdown();
        this.executor = null;
        this.messageService.stop();
        this.messageService = null;
    }

    public MessageService getProxiedService() {
        return this.messageService;
    }

    @Override
    public ConnectionNode getDefault() {
        return this.getProxiedService().getDefault();
    }

    @Override
    public ConnectionNode get(NodeInfo nodeInfo) {
        return this.getProxiedService().get(nodeInfo);
    }

    @Override
    public Collection<NodeInfo> getAvailableConnections() {
        return this.getProxiedService().getAvailableConnections();
    }

    @Override
    public int size() {
        return this.getProxiedService().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getProxiedService().isEmpty();
    }
}

