/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.osgi.framework.Bundle;

public class OperationApplication
implements IApplication {
    public Object start(IApplicationContext context) {
        String[] inputArgs = Platform.getApplicationArgs();
        if (inputArgs.length < 2) {
            System.out.printf("usage: bundle class; not %d arguments", inputArgs.length);
        }
        try {
            IOperation operation = this.loadOperation(inputArgs[0], inputArgs[1]);
            Operations.executeWorkAndCheckStatus((IOperation)operation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return IApplication.EXIT_OK;
    }

    private IOperation loadOperation(String bundleName, String className) throws IllegalAccessException, ClassNotFoundException {
        try {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                throw new OseeArgumentException("Platform.getBundle found not find [%s]", new Object[]{bundleName});
            }
            Class clazz = bundle.loadClass(className);
            return (IOperation)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new OseeArgumentException("%s: does [%s] have an no argument constructor?", new Object[]{ex, className});
        }
    }

    public void stop() {
    }
}

