/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.core.access.AtsArtifactChecks;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class MoveTeamWorkflowsOperation
extends AbstractOperation {
    private final TeamWorkFlowArtifact destTeamWorkflow;
    private final Collection<TeamWorkFlowArtifact> sourceTeamWorkflows;
    private final String destActionTitle;

    public MoveTeamWorkflowsOperation(String operationName, TeamWorkFlowArtifact destTeamWorkflows, Collection<TeamWorkFlowArtifact> sourceTeamWorkflows, String destActionTitle) {
        super(operationName, "org.eclipse.osee.ats.ide");
        this.destTeamWorkflow = destTeamWorkflows;
        this.sourceTeamWorkflows = sourceTeamWorkflows;
        this.destActionTitle = destActionTitle;
    }

    protected void doWork(IProgressMonitor monitor) {
        if (this.sourceTeamWorkflows.isEmpty()) {
            throw new OseeArgumentException("ERROR", new Object[]{"Must provide Source Team Workflow(s)."});
        }
        if (this.destTeamWorkflow == null) {
            throw new OseeArgumentException("ERROR", new Object[]{"Must provide Destination Team Workflow."});
        }
        try {
            AtsArtifactChecks.setDeletionChecksEnabled((boolean)false);
            SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)this.getName());
            if (Strings.isValid((String)this.destActionTitle)) {
                ((Artifact)this.destTeamWorkflow.getParentAction().getStoreObject()).setName(this.destActionTitle);
            }
            for (TeamWorkFlowArtifact teamArt : this.sourceTeamWorkflows) {
                IAtsAction parentAction = teamArt.getParentAction();
                teamArt.deleteRelations(AtsRelationTypes.ActionToWorkflow_Action);
                teamArt.clearCaches();
                teamArt.addRelation(AtsRelationTypes.ActionToWorkflow_Action, (Artifact)this.destTeamWorkflow.getParentAction().getStoreObject());
                teamArt.persist(transaction);
                boolean allDeleted = true;
                for (IRelationLink link : AtsApiService.get().getRelationResolver().getRelations(parentAction.getArtifactId(), AtsRelationTypes.ActionToWorkflow_TeamWorkflow)) {
                    if (link.isDeleted()) continue;
                    allDeleted = false;
                }
                if (!allDeleted) continue;
                AtsApiService.get().getQueryServiceIde().getArtifact(parentAction.getArtifactId()).deleteAndPersist(transaction);
            }
            ((Artifact)this.destTeamWorkflow.getParentAction().getStoreObject()).persist(transaction);
            transaction.execute();
        }
        finally {
            AtsArtifactChecks.setDeletionChecksEnabled((boolean)true);
        }
    }
}

