/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactStoredWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XTextDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WfeTitleHeader
extends Composite {
    private final IAtsWorkItem workItem;
    private XTextDam titleText;

    public WfeTitleHeader(Composite parent, int style, IAtsWorkItem workItem, WorkflowEditor editor, XModifiedListener xModListener) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)true));
        editor.getToolkit().adapt((Composite)this);
        try {
            this.titleText = new XTextDam("Title");
            this.titleText.setAttributeType((Artifact)workItem.getStoreObject(), (AttributeTypeToken)CoreAttributeTypes.Name);
            this.titleText.createWidgets((Composite)this, 1);
            this.titleText.adaptControls((FormToolkit)editor.getToolkit());
            XWidgetUtility.setLabelFontsBold((XWidget)this.titleText);
            this.titleText.addXModifiedListener(xModListener);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            this.titleText = null;
        }
        this.refresh();
    }

    public void refresh() {
        this.titleText.setAttributeType((Artifact)this.workItem.getStoreObject(), (AttributeTypeToken)CoreAttributeTypes.Name);
    }

    public XTextDam getTitleText() {
        return this.titleText;
    }

    public XResultData isXWidgetDirty(XResultData rd) {
        if (this.titleText != null && this.titleText.isDirty().isTrue()) {
            rd.error("Title is dirty");
        }
        return rd;
    }

    public Result isXWidgetSavable() {
        IStatus status = this.titleText.isValid();
        if (!status.isOK()) {
            return new Result(false, status.getMessage());
        }
        return Result.TrueResult;
    }

    public void getDirtyIArtifactWidgets(List<ArtifactStoredWidget> artWidgets) {
        if (this.titleText.isDirty().isTrue()) {
            artWidgets.add((ArtifactStoredWidget)this.titleText);
        }
    }

    public Collection<XWidget> getXWidgets(ArrayList<XWidget> widgets) {
        widgets.add((XWidget)this.titleText);
        return widgets;
    }
}

