/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.core.util.HoursSpentUtil;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.ide.column.RemainingHoursColumn;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeEstimatedHoursHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfePercentCompleteHeader;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;

public class WfeMetricsHeader
extends Composite {
    private final IAtsWorkItem workItem;
    private Label percentLabel;
    private Label hoursSpentLabel;
    private Label remainHoursLabel;
    private WfePercentCompleteHeader totalPercentHeader;
    private WfeEstimatedHoursHeader estimatedHoursHeader;

    public WfeMetricsHeader(Composite parent, XFormToolkit toolkit, IAtsWorkItem workItem, WorkflowEditor editor, IManagedForm managedForm) {
        super(parent, 0);
        this.workItem = workItem;
        try {
            int numColumns = 8;
            if (!AtsApiService.get().getWorkDefinitionService().isStateWeightingEnabled(workItem.getWorkDefinition())) {
                numColumns = 10;
            }
            toolkit.adapt((Composite)this);
            this.setLayout((Layout)ALayout.getZeroMarginLayout((int)numColumns, (boolean)false));
            this.setLayoutData(new GridData(768));
            if (AtsApiService.get().getWorkDefinitionService().isStateWeightingEnabled(workItem.getWorkDefinition())) {
                this.percentLabel = FormsUtil.createLabelValue((XFormToolkit)toolkit, (Composite)this, (String)"Total Percent: ", (String)"", (String)"Calculation: Sum of percent for all states (including all tasks and reviews) / # statusable states (if configured)");
            } else {
                this.totalPercentHeader = new WfePercentCompleteHeader(this, 2, workItem, editor);
                this.totalPercentHeader.setBackground(parent.getParent().getParent().getBackground());
            }
            this.estimatedHoursHeader = new WfeEstimatedHoursHeader(this, 2, workItem, editor);
            this.estimatedHoursHeader.setBackground(parent.getParent().getParent().getBackground());
            this.hoursSpentLabel = FormsUtil.createLabelValue((XFormToolkit)toolkit, (Composite)this, (String)"Total Hours Spent: ", (String)"", (String)"Calculation: Sum of all hours spent for all tasks, reviews and in each state");
            this.remainHoursLabel = FormsUtil.createLabelValue((XFormToolkit)toolkit, (Composite)this, (String)"Remaining Hours: ", (String)"", (String)RemainingHoursColumn.getInstance().getDescription());
            this.refresh();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        if (!Widgets.isAccessible((Widget)this.hoursSpentLabel)) {
            return;
        }
        try {
            if (this.totalPercentHeader != null) {
                this.totalPercentHeader.refresh();
            }
            if (this.percentLabel != null && !this.percentLabel.isDisposed()) {
                this.percentLabel.setText(String.valueOf(PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)this.workItem, (AtsApi)AtsApiService.get())));
            }
            if (this.estimatedHoursHeader != null) {
                this.estimatedHoursHeader.refresh();
            }
            if (this.hoursSpentLabel != null && !this.hoursSpentLabel.isDisposed()) {
                this.hoursSpentLabel.setText(String.valueOf(AtsUtil.doubleToI18nString((double)HoursSpentUtil.getHoursSpentTotal((IAtsObject)this.workItem, (AtsApi)AtsApiService.get()))));
            }
            if (this.hoursSpentLabel != null && !this.hoursSpentLabel.isDisposed()) {
                Result result = RemainingHoursColumn.isRemainingHoursValid(this.workItem);
                if (result.isFalse()) {
                    this.remainHoursLabel.setText("Error" + result.getText());
                } else {
                    this.remainHoursLabel.setText(String.valueOf(AtsUtil.doubleToI18nString((double)RemainingHoursColumn.getRemainingHours(this.workItem))));
                }
            }
            this.getParent().layout();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        if (this.percentLabel != null) {
            this.percentLabel.update();
        }
        this.layout();
    }
}

