/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.members;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.editor.tab.members.WfeMembersTab;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalManager;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Menu;

public class WfeMembersTabActions {
    private static Action toTask;
    private static Action toAction;
    private static Action toWorkFlow;
    private static Action toReview;
    private static Action toGoal;
    private final String ACTIONS = "Open as Actions in World Editor";
    private final String GOALS = "Open as Goals in World Editor";
    private final String WORKFLOWS = "Open as WorkFlows in World Editor";
    private final String TASKS = "Open as Tasks in World Editor";
    private final String REVIEWS = "Open as Reviews in World Editor";
    private final WorldComposite worldComposite;

    public WfeMembersTabActions(WfeMembersTab membersTab) {
        this.worldComposite = membersTab.getWorldComposite();
    }

    public void createActions(Menu fMenu) {
        this.getActionsMenuItem();
        this.getGoalsMenuItem();
        this.getWorkFlowsMenuItem();
        this.getTasksMenuItem();
        this.getReviewsMenuItem();
        this.addActionToMenu(fMenu, toAction);
        this.addActionToMenu(fMenu, toGoal);
        this.addActionToMenu(fMenu, toWorkFlow);
        this.addActionToMenu(fMenu, toTask);
        this.addActionToMenu(fMenu, toReview);
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void openAsActions() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Open as Actions in World Editor"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<Artifact> arts = new HashSet<Artifact>();
                    for (Artifact art : artifacts) {
                        Artifact parentArt;
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            arts.add(art);
                            continue;
                        }
                        if (!(art instanceof AbstractWorkflowArtifact) || (parentArt = (Artifact)((AbstractWorkflowArtifact)art).getParentAction().getStoreObject()) == null) continue;
                        arts.add(parentArt);
                    }
                    WorldEditor.open(new WorldEditorSimpleProvider("Actions", arts));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void openAsGoals() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Open as Goals in World Editor"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<Artifact> goals = new HashSet<Artifact>();
                    new GoalManager().getCollectors(artifacts, goals, true);
                    WorldEditor.open(new WorldEditorSimpleProvider("Goals", goals));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void openAsWorkFlows() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Open as WorkFlows in World Editor"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<Artifact> arts = new HashSet<Artifact>();
                    for (Artifact art : artifacts) {
                        Artifact parentArt;
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getWorkItemService().getTeams((Object)art))));
                            continue;
                        }
                        if (!(art instanceof AbstractWorkflowArtifact) || (parentArt = (Artifact)((AbstractWorkflowArtifact)art).getParentTeamWorkflow()) == null) continue;
                        arts.add(parentArt);
                    }
                    WorldEditor.open(new WorldEditorSimpleProvider("WorkFlows", arts));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void openAsTask() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Open as Tasks in World Editor"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet arts = new HashSet();
                    for (Artifact art : artifacts) {
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)art)) {
                                arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getTaskService().getTasks(team))));
                            }
                            continue;
                        }
                        if (!(art instanceof TeamWorkFlowArtifact)) continue;
                        arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)art)))));
                    }
                    WorldEditor.open(new WorldEditorSimpleProvider("Tasks", arts));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void openAsReview() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Open as Reviews in World Editor"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<AbstractReviewArtifact> arts = new HashSet<AbstractReviewArtifact>();
                    for (Artifact art : artifacts) {
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)art)) {
                                arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getReviewService().getReviews(team))));
                            }
                            continue;
                        }
                        if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                        arts.addAll(ReviewManager.getReviews((TeamWorkFlowArtifact)art));
                    }
                    WorldEditor.open(new WorldEditorSimpleProvider("Reviews", arts));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    private Action getActionsMenuItem() {
        toAction = new Action("Open as Actions in World Editor", 1){

            public void run() {
                WfeMembersTabActions.this.openAsActions();
            }
        };
        toAction.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.ACTION));
        return toAction;
    }

    private Action getGoalsMenuItem() {
        toGoal = new Action("Open as Goals in World Editor", 1){

            public void run() {
                WfeMembersTabActions.this.openAsGoals();
            }
        };
        toGoal.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.GOAL));
        return toGoal;
    }

    private Action getWorkFlowsMenuItem() {
        toWorkFlow = new Action("Open as WorkFlows in World Editor", 1){

            public void run() {
                WfeMembersTabActions.this.openAsWorkFlows();
            }
        };
        toWorkFlow.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.WORKFLOW));
        return toWorkFlow;
    }

    private Action getTasksMenuItem() {
        toTask = new Action("Open as Tasks in World Editor", 1){

            public void run() {
                WfeMembersTabActions.this.openAsTask();
            }
        };
        toTask.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.TASK));
        return toTask;
    }

    private Action getReviewsMenuItem() {
        toReview = new Action("Open as Reviews in World Editor", 1){

            public void run() {
                WfeMembersTabActions.this.openAsReview();
            }
        };
        toReview.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.REVIEW));
        return toReview;
    }

    public void createDropDownMenuActions() {
        this.getActionsMenuItem();
        this.getGoalsMenuItem();
        this.getWorkFlowsMenuItem();
        this.getTasksMenuItem();
        this.getReviewsMenuItem();
    }
}

