/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class BranchStatusColumn
extends BackgroundLoadingPreComputedColumn {
    public static BranchStatusColumn instance = new BranchStatusColumn();

    public static BranchStatusColumn getInstance() {
        return instance;
    }

    private BranchStatusColumn() {
        super("ats.column.branchStatus", "Branch Status", 40, XViewerAlign.Center, false, SortDataType.String, false, null);
    }

    public BranchStatusColumn copy() {
        BranchStatusColumn newXCol = new BranchStatusColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        String value = "";
        try {
            if (workItem.isTeamWorkflow()) {
                value = this.getBranchStatus((IAtsTeamWorkflow)workItem);
            }
        }
        catch (OseeCoreException ex) {
            value = LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return value;
    }

    public String getBranchStatus(IAtsTeamWorkflow teamWf) {
        block5: {
            try {
                if (!AtsApiService.get().getBranchService().isWorkingBranchInWork(teamWf)) break block5;
                return "Working";
            }
            catch (Exception ex) {
                return "Exception: " + ex.getLocalizedMessage();
            }
        }
        if (AtsApiService.get().getBranchService().isCommittedBranchExists(teamWf)) {
            if (!AtsApiService.get().getBranchService().isAllObjectsToCommitToConfigured(teamWf) || !AtsApiService.get().getBranchService().isBranchesAllCommitted(teamWf)) {
                return "Needs Commit";
            }
            return "Committed";
        }
        return "";
    }
}

