/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.LinkedList;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.JaxAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.agile.navigate.AgileNavigateItemProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.osee.framework.ui.skynet.cm.OseeCmEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.ArtifactTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;

public class CreateNewAgileSprint
extends XNavigateItemAction {
    public CreateNewAgileSprint() {
        super("Create new Agile Sprint", AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_SPRINT), new XNavItemCat[]{AgileNavigateItemProvider.AGILE_CONFIG});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        EntryDialog ed;
        LinkedList<Artifact> activeTeams = new LinkedList<Artifact>();
        for (Artifact agTeam : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.AgileTeam, (BranchId)AtsApiService.get().getAtsBranch())) {
            if (!((Boolean)agTeam.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue()) continue;
            activeTeams.add(agTeam);
        }
        FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog(this.getName(), "Select Agile Team", activeTeams, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new ArtifactLabelProvider());
        if (dialog.open() == 0 && (ed = new EntryDialog(this.getName(), "Enter new Agile Sprint name(s) (comma delimited)")).open() == 0 && Strings.isValid((String)ed.getEntry())) {
            try {
                AgileEndpointApi ageilEp = AtsApiService.get().getServerEndpoints().getAgileEndpoint();
                JaxNewAgileSprint newSprint = new JaxNewAgileSprint();
                Artifact firstArtifact = dialog.getSelectedFirst();
                if (firstArtifact == null) {
                    throw new OseeCoreException("Must make a selection", new Object[0]);
                }
                Long teamId = firstArtifact.getId();
                String[] stringArray = ed.getEntry().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    newSprint.setName(name);
                    newSprint.setTeamId(teamId.longValue());
                    Response response = ageilEp.createSprint(teamId.longValue(), newSprint);
                    JaxAgileSprint sprint = null;
                    if (response != null) {
                        sprint = (JaxAgileSprint)response.readEntity(JaxAgileSprint.class);
                    }
                    if (sprint == null) {
                        AWorkbench.popup((String)"Error creating Agile Team [%s]", (String)(response != null ? response.toString() : ""));
                        return;
                    }
                    long id = sprint.getId();
                    Artifact sprintArt = ArtifactQuery.getArtifactFromId((long)id, (BranchId)AtsApiService.get().getAtsBranch());
                    sprintArt.getParent().reloadAttributesAndRelations();
                    AtsEditors.openArtifactById((ArtifactId)sprintArt, OseeCmEditor.CmPcrEditor);
                    ++n2;
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }
}

