/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleOseeFormatter
extends Formatter {
    Date dat = new Date();
    private final StringBuilder sb = new StringBuilder();
    private final String lineSeparator = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        this.sb.setLength(0);
        this.dat.setTime(record.getMillis());
        this.sb.append(this.dat.toString());
        this.sb.append("      ");
        this.sb.append(record.getLoggerName());
        this.sb.append(this.lineSeparator);
        Throwable th = new Throwable();
        StackTraceElement[] elements = th.getStackTrace();
        boolean captureNextItem = false;
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement el = stackTraceElementArray[n2];
            if (el.getClassName().contains("OseeLog")) {
                captureNextItem = true;
            } else if (captureNextItem) {
                this.sb.append(String.format("%s   %s   %s (%d)", record.getLevel().getLocalizedName(), el.getClassName(), el.getMethodName(), el.getLineNumber()));
                this.sb.append(this.lineSeparator);
                break;
            }
            ++n2;
        }
        String message = this.formatMessage(record);
        if (!captureNextItem) {
            this.sb.append(record.getLevel().getLocalizedName());
            this.sb.append("      ");
        }
        this.sb.append(message);
        this.sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            this.sb.append(sw.toString());
        }
        return this.sb.toString();
    }
}

