/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.util.CancelWatcher;
import org.eclipse.osee.framework.ui.plugin.util.JobbedNode;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.IContentProviderRunnable;

public class GetChildrenJob
extends Job {
    private final Viewer viewer;
    private final JobbedNode parent;
    private final IContentProviderRunnable runnable;

    public GetChildrenJob(String name, Viewer viewer, JobbedNode parent, IContentProviderRunnable runnable) {
        super("Fetching children" + (name == null ? "" : " for " + name));
        if (viewer == null) {
            throw new IllegalArgumentException("view can not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be null.");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable can not be null.");
        }
        this.viewer = viewer;
        this.parent = parent;
        this.runnable = runnable;
    }

    protected final IStatus run(IProgressMonitor monitor) {
        block6: {
            CancelWatcher watcher = new CancelWatcher(this.getThread(), monitor);
            watcher.start();
            try {
                try {
                    Object[] children = this.runnable.run(this.parent.getBackingData());
                    if (!monitor.isCanceled()) {
                        this.parent.setChildren(children);
                        Displays.ensureInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GetChildrenJob.this.viewer.refresh();
                            }
                        });
                        break block6;
                    }
                    this.parent.cancelled();
                }
                catch (Exception ex) {
                    OseeLog.log(UiPluginConstants.class, (Level)Level.SEVERE, (Throwable)ex);
                    this.parent.cancelled(ex);
                    watcher.done();
                    monitor.done();
                }
            }
            finally {
                watcher.done();
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }
}

