/**
 * Copyright (c) 2013 itemis AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Mark Broerkens - initial API and implementation
 * 
 */
package org.eclipse.rmf.reqif10.xhtml;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.namespace.SpaceType;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Blockquote Type</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getXhtmlBlockMix <em>Xhtml Block Mix</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getH1 <em>H1</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getH2 <em>H2</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getH3 <em>H3</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getH4 <em>H4</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getH5 <em>H5</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getH6 <em>H6</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getUl <em>Ul</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getOl <em>Ol</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getDl <em>Dl</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getP <em>P</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getDiv <em>Div</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getPre <em>Pre</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getBlockquote <em>Blockquote</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getAddress <em>Address</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getHr <em>Hr</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getTable <em>Table</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getIns <em>Ins</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getDel <em>Del</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getCite <em>Cite</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getClass_ <em>Class</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getId <em>Id</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getLang <em>Lang</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getSpace <em>Space</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getStyle <em>Style</em>}</li>
 * <li>{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getTitle <em>Title</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType()
 * @model extendedMetaData="name='blockquote' kind='elementOnly'"
 * @generated
 */
public interface XhtmlBlockquoteType extends EObject {
	/**
	 * Returns the value of the '<em><b>Xhtml Block Mix</b></em>' attribute list. The list contents are of type
	 * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Xhtml Block Mix</em>' attribute list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Xhtml Block Mix</em>' attribute list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_XhtmlBlockMix()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry" many="true"
	 *        extendedMetaData="kind='group' name='XhtmlBlockMix:0'"
	 * @generated
	 */
	FeatureMap getXhtmlBlockMix();

	/**
	 * Returns the value of the '<em><b>H1</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlH1Type}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>H1</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>H1</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_H1()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='h1' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlH1Type> getH1();

	/**
	 * Returns the value of the '<em><b>H2</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlH2Type}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>H2</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>H2</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_H2()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='h2' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlH2Type> getH2();

	/**
	 * Returns the value of the '<em><b>H3</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlH3Type}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>H3</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>H3</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_H3()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='h3' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlH3Type> getH3();

	/**
	 * Returns the value of the '<em><b>H4</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlH4Type}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>H4</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>H4</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_H4()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='h4' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlH4Type> getH4();

	/**
	 * Returns the value of the '<em><b>H5</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlH5Type}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>H5</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>H5</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_H5()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='h5' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlH5Type> getH5();

	/**
	 * Returns the value of the '<em><b>H6</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlH6Type}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>H6</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>H6</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_H6()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='h6' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlH6Type> getH6();

	/**
	 * Returns the value of the '<em><b>Ul</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlUlType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ul</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Ul</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Ul()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='ul' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlUlType> getUl();

	/**
	 * Returns the value of the '<em><b>Ol</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlOlType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ol</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Ol</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Ol()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='ol' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlOlType> getOl();

	/**
	 * Returns the value of the '<em><b>Dl</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlDlType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Dl</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Dl</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Dl()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='dl' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlDlType> getDl();

	/**
	 * Returns the value of the '<em><b>P</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlPType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>P</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>P</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_P()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='p' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlPType> getP();

	/**
	 * Returns the value of the '<em><b>Div</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlDivType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Div</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Div</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Div()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='div' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlDivType> getDiv();

	/**
	 * Returns the value of the '<em><b>Pre</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlPreType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Pre</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Pre</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Pre()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='pre' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlPreType> getPre();

	/**
	 * Returns the value of the '<em><b>Blockquote</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Blockquote</em>' containment reference list isn't clear, there really should be more
	 * of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Blockquote</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Blockquote()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='blockquote' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlBlockquoteType> getBlockquote();

	/**
	 * Returns the value of the '<em><b>Address</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlAddressType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Address</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Address</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Address()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='address' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlAddressType> getAddress();

	/**
	 * Returns the value of the '<em><b>Hr</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlHrType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hr</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Hr</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Hr()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='hr' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlHrType> getHr();

	/**
	 * Returns the value of the '<em><b>Table</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlTableType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Table</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Table</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Table()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='table' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlTableType> getTable();

	/**
	 * Returns the value of the '<em><b>Ins</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlEditType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ins</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Ins</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Ins()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='ins' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlEditType> getIns();

	/**
	 * Returns the value of the '<em><b>Del</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.rmf.reqif10.xhtml.XhtmlEditType}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Del</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Del</em>' containment reference list.
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Del()
	 * @model containment="true" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='del' namespace='##targetNamespace' group='#XhtmlBlockMix:0'"
	 * @generated
	 */
	EList<XhtmlEditType> getDel();

	/**
	 * Returns the value of the '<em><b>Cite</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Cite</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Cite</em>' attribute.
	 * @see #setCite(String)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Cite()
	 * @model dataType="org.eclipse.rmf.reqif10.datatypes.URI" extendedMetaData="kind='attribute' name='cite'"
	 * @generated
	 */
	String getCite();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getCite <em>Cite</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Cite</em>' attribute.
	 * @see #getCite()
	 * @generated
	 */
	void setCite(String value);

	/**
	 * Returns the value of the '<em><b>Class</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Class</em>' attribute.
	 * @see #setClass(String)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Class()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" extendedMetaData="kind='attribute' name='class'"
	 * @generated
	 */
	String getClass_();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getClass_ <em>Class</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Class</em>' attribute.
	 * @see #getClass_()
	 * @generated
	 */
	void setClass(String value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Id()
	 * @model id="true" dataType="org.eclipse.emf.ecore.xml.type.ID" extendedMetaData="kind='attribute' name='id'"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Lang</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc --> <!--
	 * begin-model-doc --> <div xmlns="http://www.w3.org/1999/xhtml"> <h3>lang (as an attribute name)</h3>
	 * <p>
	 * denotes an attribute whose value is a language code for the natural language of the content of any element; its
	 * value is inherited. This name is reserved by virtue of its definition in the XML specification.
	 * </p>
	 * </div> <div xmlns="http://www.w3.org/1999/xhtml"> <h4>Notes</h4>
	 * <p>
	 * Attempting to install the relevant ISO 2- and 3-letter codes as the enumerated possible values is probably never
	 * going to be a realistic possibility.
	 * </p>
	 * <p>
	 * See BCP 47 at <a href="http://www.rfc-editor.org/rfc/bcp/bcp47.txt">
	 * http://www.rfc-editor.org/rfc/bcp/bcp47.txt</a> and the IANA language subtag registry at <a
	 * href="http://www.iana.org/assignments/language-subtag-registry">
	 * http://www.iana.org/assignments/language-subtag-registry</a> for further information.
	 * </p>
	 * <p>
	 * The union allows for the 'un-declaration' of xml:lang with the empty string.
	 * </p>
	 * </div> <!-- end-model-doc -->
	 * 
	 * @return the value of the '<em>Lang</em>' attribute.
	 * @see #setLang(String)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Lang()
	 * @model dataType="org.eclipse.emf.ecore.xml.namespace.LangType"
	 *        extendedMetaData="kind='attribute' name='lang' namespace='http://www.w3.org/XML/1998/namespace'"
	 * @generated
	 */
	String getLang();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getLang <em>Lang</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Lang</em>' attribute.
	 * @see #getLang()
	 * @generated
	 */
	void setLang(String value);

	/**
	 * Returns the value of the '<em><b>Space</b></em>' attribute. The default value is <code>"preserve"</code>. The
	 * literals are from the enumeration {@link org.eclipse.emf.ecore.xml.namespace.SpaceType}. <!-- begin-user-doc -->
	 * <!-- end-user-doc --> <!-- begin-model-doc --> <div xmlns="http://www.w3.org/1999/xhtml"> <h3>space (as an
	 * attribute name)</h3>
	 * <p>
	 * denotes an attribute whose value is a keyword indicating what whitespace processing discipline is intended for
	 * the content of the element; its value is inherited. This name is reserved by virtue of its definition in the XML
	 * specification.
	 * </p>
	 * </div> <!-- end-model-doc -->
	 * 
	 * @return the value of the '<em>Space</em>' attribute.
	 * @see org.eclipse.emf.ecore.xml.namespace.SpaceType
	 * @see #isSetSpace()
	 * @see #unsetSpace()
	 * @see #setSpace(SpaceType)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Space()
	 * @model default="preserve" unsettable="true"
	 *        extendedMetaData="kind='attribute' name='space' namespace='http://www.w3.org/XML/1998/namespace'"
	 * @generated
	 */
	SpaceType getSpace();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getSpace <em>Space</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Space</em>' attribute.
	 * @see org.eclipse.emf.ecore.xml.namespace.SpaceType
	 * @see #isSetSpace()
	 * @see #unsetSpace()
	 * @see #getSpace()
	 * @generated
	 */
	void setSpace(SpaceType value);

	/**
	 * Unsets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getSpace <em>Space</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #isSetSpace()
	 * @see #getSpace()
	 * @see #setSpace(SpaceType)
	 * @generated
	 */
	void unsetSpace();

	/**
	 * Returns whether the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getSpace
	 * <em>Space</em>}' attribute is set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Space</em>' attribute is set.
	 * @see #unsetSpace()
	 * @see #getSpace()
	 * @see #setSpace(SpaceType)
	 * @generated
	 */
	boolean isSetSpace();

	/**
	 * Returns the value of the '<em><b>Style</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Style</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Style</em>' attribute.
	 * @see #setStyle(String)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Style()
	 * @model dataType="org.eclipse.rmf.reqif10.datatypes.CDATA" extendedMetaData="kind='attribute' name='style'"
	 * @generated
	 */
	String getStyle();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getStyle <em>Style</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Style</em>' attribute.
	 * @see #getStyle()
	 * @generated
	 */
	void setStyle(String value);

	/**
	 * Returns the value of the '<em><b>Title</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Title</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Title</em>' attribute.
	 * @see #setTitle(String)
	 * @see org.eclipse.rmf.reqif10.xhtml.XhtmlPackage#getXhtmlBlockquoteType_Title()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" extendedMetaData="kind='attribute' name='title'"
	 * @generated
	 */
	String getTitle();

	/**
	 * Sets the value of the '{@link org.eclipse.rmf.reqif10.xhtml.XhtmlBlockquoteType#getTitle <em>Title</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Title</em>' attribute.
	 * @see #getTitle()
	 * @generated
	 */
	void setTitle(String value);

} // XhtmlBlockquoteType
