/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import java.io.InputStream;
import java.util.List;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.orcs.db.internal.search.tagger.StreamMatcher;
import org.eclipse.osee.orcs.db.internal.search.util.CheckedOptions;
import org.eclipse.osee.orcs.db.internal.search.util.SecondPassScanner;
import org.eclipse.osee.orcs.db.internal.search.util.TokenOrderProcessor;
import org.eclipse.osee.orcs.db.internal.search.util.TokenOrderProcessorFactory;

public class SecondPassMatcher
implements StreamMatcher {
    private final TokenOrderProcessorFactory processorFactory;

    public SecondPassMatcher(TokenOrderProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    private String normalizeCase(QueryOption caseType, String token) {
        return caseType == QueryOption.CASE__MATCH ? token : token.toLowerCase();
    }

    @Override
    public List<MatchLocation> findInStream(InputStream inputStream, String toSearch, boolean findAllMatchLocations, QueryOption ... options) {
        CheckedOptions checkedOptions = new CheckedOptions(options);
        TokenOrderProcessor processor = this.processorFactory.createTokenProcessor(checkedOptions);
        this.parseSearchString(processor, toSearch, checkedOptions);
        this.searchStream(processor, inputStream, checkedOptions, findAllMatchLocations);
        return processor.getLocations();
    }

    private void parseSearchString(TokenOrderProcessor processor, String toSearch, CheckedOptions options) {
        try (SecondPassScanner toSearchScanner = new SecondPassScanner(toSearch, options.getDelimiter());){
            while (toSearchScanner.hasNext()) {
                String next = toSearchScanner.next();
                next = this.normalizeCase(options.getCaseType(), next);
                processor.acceptTokenToMatch(next);
            }
        }
    }

    private void searchStream(TokenOrderProcessor processor, InputStream inputStream, CheckedOptions options, boolean findAllMatchLocations) {
        try (SecondPassScanner inputStreamScanner = new SecondPassScanner(inputStream, options.getDelimiter());){
            int numTokensProcessed = 0;
            boolean isProcessorDone = false;
            while (inputStreamScanner.hasNext()) {
                if (++numTokensProcessed > processor.getTotalTokensToMatch() && QueryOption.TOKEN_COUNT__MATCH == options.getCountType()) {
                    processor.getLocations().clear();
                    break;
                }
                if (isProcessorDone && !findAllMatchLocations) break;
                String next = inputStreamScanner.next();
                next = this.normalizeCase(options.getCaseType(), next);
                MatchLocation match = inputStreamScanner.match();
                isProcessorDone = processor.processToken(next, match);
            }
            if (!isProcessorDone) {
                processor.clearAllLocations();
            }
        }
    }
}

