/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider;

import java.util.List;
import java.util.TreeMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;
import org.apache.cxf.jaxrs.security.SimpleAuthorizingFilter;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.eclipse.osee.jaxrs.server.internal.JaxRsResourceManager;

@Provider
public class OseeAuthorizingFilter
extends SimpleAuthorizingFilter {
    private AbstractAuthorizingInInterceptor interceptor;
    private JaxRsResourceManager resourceManager;

    public void filter(ContainerRequestContext context) {
        context.getSecurityContext().getUserPrincipal();
        JaxRsResourceManager.Resource resource = this.resourceManager.findResource(context);
        Message currentMessage = JAXRSUtils.getCurrentMessage();
        TreeMap protocolHeaders = (TreeMap)currentMessage.getContextualProperty("org.apache.cxf.message.Message.PROTOCOL_HEADERS");
        List referers = (List)protocolHeaders.get("Referer");
        if (resource != null && referers != null && !referers.toString().contains("coverage")) {
            try {
                this.interceptor.handleMessage(currentMessage);
            }
            catch (Exception exception) {
                context.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            }
        }
    }

    public void setInterceptor(AbstractAuthorizingInInterceptor in) {
        this.interceptor = in;
    }

    public void setResourceManager(JaxRsResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

