/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.mim.types.MimRelationChange;

public class MimDifferenceItem {
    private final ArtifactId artId;
    private boolean added = false;
    private boolean deleted = false;
    private final Map<Long, String[]> diffs;
    private final Map<ArtifactId, MimRelationChange> relationChanges;

    public MimDifferenceItem(ArtifactId artId) {
        this.artId = artId;
        this.diffs = new HashMap<Long, String[]>();
        this.relationChanges = new HashMap<ArtifactId, MimRelationChange>();
    }

    public ArtifactId getArtId() {
        return this.artId;
    }

    public Map<Long, String[]> getDiffs() {
        return this.diffs;
    }

    public Map<ArtifactId, MimRelationChange> getRelationChanges() {
        return this.relationChanges;
    }

    public boolean isAdded() {
        return this.added;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void addAttributeChange(Long attrId, String oldValue, String newValue) {
        String[] vals = new String[]{oldValue, newValue};
        this.diffs.put(attrId, vals);
    }

    public void addRelationChange(Long relationId, ArtifactId artId, boolean added) {
        this.relationChanges.put(artId, new MimRelationChange(artId, relationId, added));
    }
}

