/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;

public class InterfaceElementEndpointImpl
implements InterfaceElementEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final ArtifactId structureId;
    private final InterfaceElementApi elementApi;

    public InterfaceElementEndpointImpl(BranchId branch, UserId account, ArtifactId messageId, ArtifactId subMessageId, ArtifactId structureId, InterfaceElementApi interfaceElementApi) {
        this.account = account;
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.structureId = structureId;
        this.elementApi = interfaceElementApi;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getAllElements(long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        return this.elementApi.getAllRelated(this.branch, this.structureId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public InterfaceStructureElementToken getElement(ArtifactId elementId) {
        return this.elementApi.getRelated(this.branch, this.structureId, elementId);
    }
}

