/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.MsWordPreviewRequestData;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.WordUpdateChange;
import org.eclipse.osee.define.api.WordUpdateData;
import org.eclipse.osee.define.api.publishing.PublishingEndpoint;
import org.eclipse.osee.define.operations.publishing.PublishingPermissions;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class PublishingEndpointImpl
implements PublishingEndpoint {
    private final DefineOperations defineOperations;

    private static void verifyAccess() {
        try {
            PublishingPermissions.verify();
        }
        catch (OseeAccessDeniedException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private static void verifyAccessNonGroup() {
        try {
            PublishingPermissions.verifyNonGroup();
        }
        catch (OseeAccessDeniedException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    public PublishingEndpointImpl(DefineOperations defineOperations) {
        this.defineOperations = Objects.requireNonNull(defineOperations, "PublishingEndpointImpl::new, parameter \"defineOperations\" cannot be null.");
    }

    public List<ArtifactToken> getSharedPublishingArtifacts(BranchId branch, ArtifactId view, ArtifactId sharedFolder, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String attributeValue) {
        PublishingEndpointImpl.verifyAccess();
        try {
            return this.defineOperations.getPublishingOperations().getSharedPublishingArtifacts(branch, view, sharedFolder, artifactType, attributeType, attributeValue);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (OseeNotFoundException onfe) {
            throw new NotFoundException(onfe.getMessage(), Response.status((Response.Status)Response.Status.NOT_FOUND).build(), (Throwable)onfe);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public InputStream msWordPreview(BranchId branch, ArtifactId template, ArtifactId headArtifact, ArtifactId view) {
        PublishingEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getPublishingOperations().msWordPreview(branch, template, headArtifact, view);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public InputStream msWordPreview(BranchId branch, ArtifactId template, List<ArtifactId> artifacts, ArtifactId view) {
        PublishingEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getPublishingOperations().msWordPreview(branch, template, artifacts, view);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public InputStream msWordPreview(MsWordPreviewRequestData msWordPreviewRequestData) {
        PublishingEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getPublishingOperations().msWordPreview(msWordPreviewRequestData);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public InputStream msWordTemplatePublish(BranchId branch, ArtifactId template, ArtifactId headArtifact, ArtifactId view) {
        PublishingEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getPublishingOperations().msWordTemplatePublish(branch, template, headArtifact, view);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData wordTemplateContentData) {
        PublishingEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getPublishingOperations().renderWordTemplateContent(wordTemplateContentData);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData wordUpdateData) {
        PublishingEndpointImpl.verifyAccessNonGroup();
        try {
            return this.defineOperations.getPublishingOperations().updateWordArtifacts(wordUpdateData);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

