/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.app.OseeAppResourceTokens;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.rest.DataRightsEndpointImpl;
import org.eclipse.osee.define.rest.GitEndpointImpl;
import org.eclipse.osee.define.rest.ImportEndpointImpl;
import org.eclipse.osee.define.rest.TraceabilityEndpointImpl;
import org.eclipse.osee.define.rest.internal.DataRightsSwReqAndCodeResource;
import org.eclipse.osee.define.rest.internal.DefineBranchEndpointImpl;
import org.eclipse.osee.define.rest.internal.SystemSafetyResource;
import org.eclipse.osee.define.rest.publishing.PublishingEndpointImpl;
import org.eclipse.osee.define.rest.publishing.templatemanager.TemplateManagerEndpointImpl;
import org.eclipse.osee.define.rest.synchronization.SynchronizationEndpointImpl;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceRegistry;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;

@ApplicationPath(value="define")
public final class DefineApplication
extends Application {
    private Set<Object> singletons = null;
    private OrcsApi orcsApi = null;
    private DefineOperations defineOperations = null;
    private ActivityLog activityLog = null;
    private JdbcService jdbcService = null;

    public void setDefineApi(DefineOperations defineOperations) {
        this.defineOperations = defineOperations;
    }

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void start(Map<String, Object> properties) {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        OseeAppResourceTokens.register((IResourceRegistry)resourceRegistry);
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.singletons = Set.of(new SystemSafetyResource(this.activityLog, (IResourceRegistry)resourceRegistry, this.orcsApi), new TraceabilityEndpointImpl(this.activityLog, (IResourceRegistry)resourceRegistry, this.orcsApi, this.defineOperations), new GitEndpointImpl(this.activityLog, this.orcsApi, this.defineOperations), new DataRightsSwReqAndCodeResource(this.activityLog, (IResourceRegistry)resourceRegistry, this.orcsApi), new DataRightsEndpointImpl(this.defineOperations), new DefineBranchEndpointImpl(jdbcClient, this.orcsApi), new ImportEndpointImpl(this.defineOperations), new PublishingEndpointImpl(this.defineOperations), new SynchronizationEndpointImpl(this.defineOperations), new TemplateManagerEndpointImpl(this.defineOperations));
        this.activityLog.getDebugLogger().warn("Define Application Started - %s", new Object[]{System.getProperty("OseeApplicationServer")});
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

