/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.MsWordPreviewRequestData;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.WordUpdateChange;
import org.eclipse.osee.define.api.WordUpdateData;
import org.eclipse.osee.define.api.publishing.LinkType;
import org.eclipse.osee.define.api.publishing.PublishingOperations;
import org.eclipse.osee.define.api.publishing.PublishingOptions;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.operations.publishing.MSWordPreviewPublisher;
import org.eclipse.osee.define.operations.publishing.MSWordTemplatePublisher;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingSharedArtifactsFolder;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUpdateArtifact;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUtilities;
import org.eclipse.osee.define.util.Validation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.service.event.EventAdmin;

public class PublishingOperationsImpl
implements PublishingOperations {
    private static boolean excludeFolders = false;
    private static boolean includeFolders = true;
    private static PublishingOperationsImpl publishingOperationsImpl = null;
    private final AtsApi atsApi;
    private final DefineOperations defineOperations;
    private final EventAdmin eventAdmin;
    private final Log logger;
    private final OrcsApi orcsApi;

    public static synchronized PublishingOperationsImpl create(DefineOperations defineOperations, OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin) {
        return Objects.isNull(publishingOperationsImpl) ? (publishingOperationsImpl = new PublishingOperationsImpl(defineOperations, orcsApi, atsApi, logger, eventAdmin)) : publishingOperationsImpl;
    }

    private PublishingOperationsImpl(DefineOperations defineOperations, OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin) {
        this.defineOperations = defineOperations;
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.logger = logger;
        this.eventAdmin = eventAdmin;
    }

    public List<ArtifactToken> getSharedPublishingArtifacts(BranchId branch, ArtifactId view, ArtifactId sharedFolder, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String attributeValue) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L);
        message = Validation.verifyParameter(sharedFolder, "sharedFolder", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(artifactType, "artifactType", message, "with an Id less than minus one", p -> p.getId() < -1L);
        message = Validation.verifyParameter(attributeType, "attributeType", message, "with an Id less than minus one", p -> p.getId() < -1L);
        if (Objects.nonNull(message = Validation.verifyParameter(attributeValue, "attributeValue", message, "empty string", p -> p.isEmpty()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "getSharedPublishingArtifacts", message));
        }
        PublishingUtils publishingUtils = new PublishingUtils(this.orcsApi);
        PublishingErrorLog publishingErrorLog = new PublishingErrorLog();
        PublishingSharedArtifactsFolder publishingSharedArtifactsFolder = ArtifactTypeToken.SENTINEL.equals(artifactType) ? PublishingSharedArtifactsFolder.create(publishingUtils, publishingErrorLog, BranchId.create((Long)branch.getId(), (ArtifactId)view), "Shared Artifacts Folder", ArtifactToken.valueOf((long)sharedFolder.getId(), (BranchId)branch), (AttributeTypeId)attributeType) : PublishingSharedArtifactsFolder.create(publishingUtils, publishingErrorLog, BranchId.create((Long)branch.getId(), (ArtifactId)view), "Shared Artifacts Folder", ArtifactToken.valueOf((long)sharedFolder.getId(), (BranchId)branch), artifactType, (AttributeTypeId)attributeType);
        List<ArtifactReadable> sharedArtifacts = publishingSharedArtifactsFolder.getSharedArtifacts(attributeValue);
        if (publishingErrorLog.size() > 0) {
            StringBuilder errorLogMessage = new StringBuilder(1024);
            publishingErrorLog.publishErrorLog(errorLogMessage);
            throw new OseeNotFoundException(errorLogMessage.toString(), new Object[0]);
        }
        List<ArtifactReadable> sharedArtifactTokens = sharedArtifacts;
        return sharedArtifactTokens;
    }

    public InputStream msWordPreview(BranchId branch, ArtifactId templateArtifactId, ArtifactId headArtifact, ArtifactId view) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(templateArtifactId, "templateArtifactId", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(headArtifact, "headArtifact", message, "with an Id less than zero", p -> p.getId() < 0L);
        if (Objects.nonNull(message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordPreview", message));
        }
        return this.msWordPreviewInternal(new MsWordPreviewRequestData(new PublishingTemplateRequest("AT-" + templateArtifactId.getIdString()), BranchId.create((Long)branch.getId(), (ArtifactId)view), List.of(headArtifact)), includeFolders);
    }

    public InputStream msWordPreview(BranchId branch, ArtifactId templateArtifactId, List<ArtifactId> artifacts, ArtifactId view) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(templateArtifactId, "templateArtifactId", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L);
        if (Objects.nonNull(message = Validation.verifyParameter(artifacts, "artifact", message, "an empty list, or with an Id entry less than zero", p -> p.isEmpty() || p.stream().map(Id::getId).min(Long::compare).get() < 0L))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordPreview", message));
        }
        return this.msWordPreviewInternal(new MsWordPreviewRequestData(new PublishingTemplateRequest("AT-" + templateArtifactId.getIdString()), BranchId.create((Long)branch.getId(), (ArtifactId)view), artifacts), includeFolders);
    }

    public InputStream msWordPreview(MsWordPreviewRequestData msWordPreviewRequestData) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(msWordPreviewRequestData, "msWordPreviewRequestData", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordPreview", message));
        }
        return this.msWordPreviewInternal(msWordPreviewRequestData, includeFolders);
    }

    private InputStream msWordPreviewInternal(MsWordPreviewRequestData msWordPreviewRequestData, boolean folderInclusion) {
        PublishingTemplate publishingTemplate = this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(msWordPreviewRequestData.getPublishingTemplateRequest());
        if (publishingTemplate.isSentinel()) {
            String message = new Message().title((CharSequence)"Failed to find a publishing template.").toMessage((ToMessage)msWordPreviewRequestData).toString();
            this.logger.error(message, new Object[0]);
            throw new OseeCoreException(message, new Object[0]);
        }
        PublishingOptions publishingOptions = new PublishingOptions();
        publishingOptions.branch = msWordPreviewRequestData.getBranchId();
        publishingOptions.view = msWordPreviewRequestData.getBranchId().getViewId();
        publishingOptions.linkType = LinkType.INTERNAL_DOC_REFERENCE_USE_NAME;
        publishingOptions.excludeFolders = !folderInclusion;
        List publishArtifacts = msWordPreviewRequestData.getArtifactIds();
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                MSWordPreviewPublisher publisher = new MSWordPreviewPublisher(publishingOptions, publishingTemplate, writer, this.orcsApi, this.atsApi);
                publisher.publish(publishArtifacts);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new OseeCoreException(new StringBuilder(1024).append("MsWord Renderer for \"msWordPreview\" failed.").append("\n").append("   Publishing Branch Id: ").append(publishingOptions.branch).append("\n").append("   Publishing View Id:   ").append(publishingOptions.view).append("\n").append("   Publish Artifacts:    ").append(Objects.nonNull(publishArtifacts) ? (publishArtifacts.size() > 0 ? publishArtifacts.stream().map(Object::toString).collect(Collectors.joining(", ", "[ ", " ]")) : "(no artifacts to publish specified)") : "(no artifacts to publish specified)").append("\n").toString(), new Object[0]);
        }
        return new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
    }

    public InputStream msWordTemplatePublish(BranchId branch, ArtifactId templateArtifactId, ArtifactId headArtifact, ArtifactId view) {
        Message message = null;
        message = Validation.verifyParameter(branch, "branch", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(templateArtifactId, "templateArtifactId", message, "with an Id less than zero", p -> p.getId() < 0L);
        message = Validation.verifyParameter(headArtifact, "headArtifact", message, "with an Id less than zero", p -> p.getId() < 0L);
        if (Objects.nonNull(message = Validation.verifyParameter(view, "view", message, "with an Id less than minus one", p -> p.getId() < -1L))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "msWordTemplatePublish", message));
        }
        PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest("AT-" + templateArtifactId.getIdString());
        PublishingTemplate publishingTemplate = this.defineOperations.getTemplateManagerOperations().getPublishingTemplate(publishingTemplateRequest);
        PublishingOptions publishingOptions = new PublishingOptions();
        publishingOptions.branch = branch;
        publishingOptions.view = view;
        publishingOptions.linkType = LinkType.INTERNAL_DOC_REFERENCE_USE_NAME;
        publishingOptions.excludeFolders = true;
        List<ArtifactId> publishArtifacts = List.of(headArtifact);
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                MSWordTemplatePublisher publisher = new MSWordTemplatePublisher(publishingOptions, publishingTemplate, writer, this.orcsApi, this.atsApi);
                publisher.publish(publishArtifacts);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new OseeCoreException(new StringBuilder(1024).append("MsWord Renderer for \"msWordTemplatePublish\" failed.").append("\n").append("   Publishing Branch Id: ").append(publishingOptions.branch).append("\n").append("   Publishing View Id:   ").append(publishingOptions.view).append("\n").append("   Publish Artifacts:    ").append(Objects.nonNull(publishArtifacts) ? (publishArtifacts.size() > 0 ? publishArtifacts.stream().map(Object::toString).collect(Collectors.joining(", ", "[ ", " ]")) : "(no artifacts to publish specified)") : "(no artifacts to publish specified)").append("\n").toString(), new Object[0]);
        }
        return new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
    }

    public String renderPlainText(BranchId branchId, String data) {
        int lastIndex;
        String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
        String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
        String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
        String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
        Pattern REVIEW_COMMENT = Pattern.compile("<aml:annotation[^>]*w:type=\"Word.Comment.Start\"/?>(</aml:annotation>)?[\\s\\S]+?<aml:annotation[^>]*w:type=\"Word.Comment.End\"/?>(</aml:annotation>)?[\\s\\S]+?</aml:annotation></w:r>");
        data = WordUtilities.reassignBinDataID(data);
        data = WordMlLinkHandler.renderPlainTextWithoutLinks(this.orcsApi.getQueryFactory(), branchId, data);
        data = WordUtilities.reassignBookMarkID(data);
        data = WordUtilities.removeNewLines(data);
        data = data.replaceAll("<w:p[^>]*><w:pPr>(<w:spacing w:after=\"[\\d]*\"[^>]*>)*(</w:spacing>)*<w:sectPr[^>]*>(<w:r><w:t>)?<w:ftr[^>]*>[\\s\\S]+</w:ftr>[\\s\\S]+</w:sectPr></w:pPr></w:p>", "");
        data = data.replaceAll("<w:sectPr[^>]*><w:ftr[\\s\\S]+?</w:ftr>[\\s\\S]+?</w:sectPr>", "");
        data = data.replaceAll("<w:sectPr[^>]*>(<w:type[^>]*>(</w:type>)*)*<w:pgSz[^>]*>(</w:pgSz>)*<w:pgMar[^>]*>(</w:pgMar>)*<w:cols[^>]*>(</w:cols>)*</w:sectPr>", "<w:r><w:br w:type=\"page\"/></w:r>");
        if (!(data = data.replaceAll("<w:p>[\\s||\\S]+?<w:r><w:t>NO DATA RIGHTS ARTIFACT FOUND</w:t></w:r>[\\s\\S]+?</w:p>", "")).contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
            String temp = data.substring(lastIndex);
            temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
            data = String.valueOf(data.substring(0, lastIndex)) + temp;
        }
        data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
        data = data.replaceAll(PL_STYLE, "");
        data = data.replaceAll(PL_HIGHLIGHT, "");
        Matcher commentMatch = REVIEW_COMMENT.matcher(data = data.replaceAll(EMPTY_PARAGRAPHS, ""));
        if (commentMatch.find()) {
            data = data.replaceAll("<aml:annotation[^>]*w:type=\"Word.Comment.Start\"/?>(</aml:annotation>)?", "");
            data = data.replaceAll("<aml:annotation[^>]*w:type=\"Word.Comment.End\"/?>(</aml:annotation>)?", "");
            data = data.replaceAll("<w:r[^>]*><w:rPr><w:rStyle w:val=\"CommentReference\"/?>(</w:rStyle>)?</w:rPr><aml:annotation[^>]*w:type=\"Word.Comment\"[^>]*><aml:content>[\\s\\S]+?</aml:content></aml:annotation></w:r>", "");
        }
        return data;
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData wordTemplateContentData) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(wordTemplateContentData, "wordTemplateContentData", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "renderWordTemplateContent", message));
        }
        WordTemplateContentRendererHandler wordRendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.logger);
        return wordRendererHandler.renderWordML(wordTemplateContentData);
    }

    public String renderWordTemplateContentWithApplicability(BranchId branchId, ArtifactId viewId, String data) {
        WordMLApplicabilityHandler wordHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, branchId, viewId);
        return wordHandler.previewValidApplicabilityContent(data);
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData wordUpdateData) {
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(wordUpdateData, "wordUpdateData", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "updateWordArtifacts", message));
        }
        WordUpdateArtifact updateArt = new WordUpdateArtifact(this.logger, this.orcsApi, this.eventAdmin);
        return updateArt.updateArtifacts(wordUpdateData);
    }
}

