/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.core.internal.branch.BranchUtil;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class BranchPurgeCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;
    private static final String ERROR_STRING = "Branch [%s] is a %s branch and that option was not specified!  It will not be purged!\n";

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "branch_purge";
    }

    public String getDescription() {
        return "Permenatly remove all branches matching the passed in criteria";
    }

    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: branch_purge [-R] [-D] [-A] [-B] [-P] branchUuids=<BRANCH_UUID,..>\n");
        sb.append("Synopsis:\n");
        sb.append("\tCAUTION: This command will permanently remove branches from the datastore!\n");
        sb.append("\tThis command has no effect unless the [P] option is specified, otherwise it\n");
        sb.append("\tprints what would be purged had the [P] option been specified.  Each option turns\n");
        sb.append("\tfunctionality on.  Thus, the default behavior with no options is to list the \n");
        sb.append("\tarchived, deleted, non-baseline branches and not recurse branch children.\n");
        sb.append("Options:\n");
        sb.append("\tR: Recurse branch children\n");
        sb.append("\tA: Allow Un-Archived branches\n");
        sb.append("\tD: Allow Un-Deleted branches\n");
        sb.append("\tB: Allow Baseline branches\n");
        sb.append("\tP: Purge the branches\n");
        return sb.toString();
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        ArrayList<Long> branchUuids = new ArrayList<Long>();
        String[] stringArray = params.getArray("branchUuids");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            if (Strings.isNumeric((String)uuid)) {
                branchUuids.add(Long.parseLong(uuid));
            } else {
                console.writeln("UUID listed %s is not a valid UUID", new Object[]{uuid});
            }
            ++n2;
        }
        if (branchUuids.isEmpty()) {
            console.writeln((Object)"No branch uuids where specified");
        }
        Collection options = params.getOptions();
        boolean recurse = options.contains("R");
        boolean unArchived = options.contains("A");
        boolean unDeleted = options.contains("D");
        boolean baseline = options.contains("B");
        boolean runPurge = options.contains("P");
        OrcsBranch orcsBranch = this.getOrcsApi().getBranchOps();
        return new PurgeBranchCallable(console, orcsBranch, this.getOrcsApi().getQueryFactory(), branchUuids, recurse, unArchived, unDeleted, baseline, runPurge);
    }

    private static class PurgeBranchCallable
    extends CancellableCallable<List<BranchId>> {
        private final Console console;
        private final OrcsBranch orcsBranch;
        private final List<Long> branchUuids;
        private final boolean recurse;
        private final boolean includeUnarchived;
        private final boolean includeUndeleted;
        private final boolean includeBaseline;
        private final boolean runPurge;
        private final QueryFactory queryFactory;

        public PurgeBranchCallable(Console console, OrcsBranch orcsBranch, QueryFactory queryFactory, List<Long> branchUuids, boolean recurse, boolean unArchived, boolean unDeleted, boolean baseline, boolean runPurge) {
            this.console = console;
            this.orcsBranch = orcsBranch;
            this.queryFactory = queryFactory;
            this.branchUuids = branchUuids;
            this.recurse = recurse;
            this.includeUnarchived = unArchived;
            this.includeUndeleted = unDeleted;
            this.includeBaseline = baseline;
            this.runPurge = runPurge;
        }

        private boolean filterBranch(Branch branch) {
            if (!this.includeBaseline && branch.getBranchType().isBaselineBranch()) {
                this.console.writeln(BranchPurgeCommand.ERROR_STRING, new Object[]{branch, branch.getBranchType()});
                return true;
            }
            if (!this.includeUnarchived && !branch.isArchived()) {
                this.console.writeln(BranchPurgeCommand.ERROR_STRING, new Object[]{branch, "archived"});
                return true;
            }
            if (!this.includeUndeleted && branch.getBranchState() != BranchState.DELETED) {
                this.console.writeln(BranchPurgeCommand.ERROR_STRING, new Object[]{branch, branch.getBranchState()});
                return true;
            }
            return false;
        }

        private Collection<Branch> getBranchesToPurge() {
            HashSet<Branch> specifiedBranches = new HashSet<Branch>();
            for (Long uuid : this.branchUuids) {
                if (uuid <= 0L) {
                    this.console.writeln("UUID listed %s is not a valid UUID", new Object[]{uuid});
                    continue;
                }
                Branch cached = (Branch)((BranchQuery)this.queryFactory.branchQuery().andId(BranchId.valueOf((Long)uuid))).getResults().getExactlyOne();
                if (cached == null) continue;
                specifiedBranches.add(cached);
            }
            HashSet<Branch> branchesToPurge = this.recurse ? this.getChildBranchesToPurge(specifiedBranches) : specifiedBranches;
            Iterator iter = branchesToPurge.iterator();
            while (iter.hasNext()) {
                if (!this.filterBranch((Branch)iter.next())) continue;
                iter.remove();
            }
            return branchesToPurge;
        }

        private Collection<Branch> getChildBranchesToPurge(Iterable<Branch> branches) {
            BranchQuery branchQuery = this.queryFactory.branchQuery();
            branchQuery.includeArchived();
            branchQuery.includeDeleted();
            if (this.includeBaseline) {
                branchQuery.andIsOfType(new BranchType[]{BranchType.WORKING, BranchType.MERGE, BranchType.PORT, BranchType.BASELINE});
            } else {
                branchQuery.andIsOfType(new BranchType[]{BranchType.WORKING, BranchType.MERGE, BranchType.PORT});
            }
            if (this.includeUndeleted) {
                branchQuery.andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED, BranchState.COMMITTED, BranchState.REBASELINED, BranchState.DELETED, BranchState.REBASELINE_IN_PROGRESS, BranchState.COMMIT_IN_PROGRESS, BranchState.CREATION_IN_PROGRESS, BranchState.DELETE_IN_PROGRESS, BranchState.PURGE_IN_PROGRESS, BranchState.PURGED});
            } else {
                branchQuery.andStateIs(new BranchState[]{BranchState.DELETED});
            }
            HashSet<Branch> results = new HashSet<Branch>();
            for (Branch parent : branches) {
                for (Branch branch : ((BranchQuery)branchQuery.andIsChildOf((BranchId)parent)).getResults()) {
                    if (!this.includeUnarchived && !branch.isArchived()) continue;
                    results.add(branch);
                }
            }
            if (this.recurse) {
                results.addAll(this.getChildBranchesToPurge(new ArrayList<Branch>(results)));
            }
            return results;
        }

        public List<BranchId> call() throws Exception {
            Collection<Branch> branchesToPurge = this.getBranchesToPurge();
            Conditions.checkNotNull(branchesToPurge, (String)"branchesToPurge");
            if (!branchesToPurge.isEmpty()) {
                List<Branch> orderedBranches = BranchUtil.orderByParentReadable(branchesToPurge);
                for (BranchToken branchToken : orderedBranches) {
                    this.console.writeln("Branch [%s] will be purged!", new Object[]{branchToken});
                }
                LinkedList<BranchId> linkedList = new LinkedList<BranchId>();
                if (this.runPurge) {
                    int size = orderedBranches.size();
                    int count = 0;
                    for (BranchId branchId : orderedBranches) {
                        this.console.writeln("Purging Branch [%s of %s]: [%s]", new Object[]{++count, size, branchId});
                        Callable callable = this.orcsBranch.purgeBranch(branchId, false);
                        linkedList.addAll((Collection)callable.call());
                    }
                }
                return linkedList;
            }
            this.console.writeln((Object)"no branches matched specified criteria");
            return null;
        }
    }
}

